/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.util;

import ch.sourcepond.utils.podescoin.api.Recipient;
import ch.sourcepond.utils.podescoin.internal.util.FieldCollector;
import ch.sourcepond.utils.podescoin.internal.util.PodesCoinClassLoader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import sun.misc.Unsafe;

public class PodesCoinObjectOutputStream
extends ObjectOutputStream {
    private static final Unsafe UNSAFE;
    private final PodesCoinClassLoader loader;

    public PodesCoinObjectOutputStream(PodesCoinClassLoader pLoader, OutputStream out) throws IOException {
        super(out);
        this.loader = pLoader;
        this.enableReplaceObject(true);
    }

    private Field setAccessible(Field pField) {
        pField.setAccessible(true);
        return pField;
    }

    private Object cloneObject(Object obj) throws IOException {
        if (obj != null && obj.getClass().isAnnotationPresent(Recipient.class)) {
            try {
                Class<?> targetType = this.loader.loadClass(obj.getClass().getName());
                Object clone = UNSAFE.allocateInstance(targetType);
                for (Map.Entry entry : new FieldCollector(obj.getClass(), targetType).entrySet()) {
                    Field sourceField = this.setAccessible((Field)entry.getKey());
                    Field targetField = this.setAccessible((Field)entry.getValue());
                    targetField.set(clone, this.cloneObject(sourceField.get(obj)));
                }
                return clone;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | SecurityException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return obj;
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        return this.cloneObject(obj);
    }

    static {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            UNSAFE = (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception e) {
            throw new Error(e.getMessage(), e);
        }
    }
}

