/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.Injector;
import ch.sourcepond.utils.podescoin.Recipient;
import ch.sourcepond.utils.podescoin.internal.SerializableClassVisitor;
import ch.sourcepond.utils.podescoin.internal.UnserializableClassWarning;
import ch.sourcepond.utils.podescoin.internal.field.ReadObjectFieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.field.WriteObjectFieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.inspector.ReadObjectInspector;
import ch.sourcepond.utils.podescoin.internal.inspector.WriteObjectInspector;
import ch.sourcepond.utils.podescoin.internal.method.ReadObjectMethodClassVisitor;
import ch.sourcepond.utils.podescoin.internal.method.WriteObjectMethodClassVisitor;
import java.io.Serializable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;

public final class Activator
implements BundleActivator,
WeavingHook,
WovenClassListener {
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.registerService(new String[]{WeavingHook.class.getName(), WovenClassListener.class.getName()}, (Object)this, null);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private boolean isAllowed(WovenClass wovenClass) {
        return !this.context.getBundle().equals(wovenClass.getBundleWiring().getBundle());
    }

    public void weave(WovenClass wovenClass) {
        if (wovenClass.getState() == 1 && this.isAllowed(wovenClass)) {
            try {
                wovenClass.setBytes(Activator.transform(wovenClass.getBytes()));
                wovenClass.getDynamicImports().add(Injector.class.getPackage().getName());
            }
            catch (Throwable e) {
                throw new WeavingException(String.format("Enhancement of %s failed!", wovenClass.getClassName()), e);
            }
        }
    }

    public void modified(WovenClass wovenClass) {
        Class cl;
        if (wovenClass.getState() == 4 && (cl = wovenClass.getDefinedClass()).isAnnotationPresent(Recipient.class) && !Serializable.class.isAssignableFrom(cl)) {
            throw new UnserializableClassWarning(cl);
        }
    }

    public static byte[] transform(byte[] pOriginalClassBytes) {
        ClassReader reader = new ClassReader(pOriginalClassBytes);
        ReadObjectInspector readObjectInspector = new ReadObjectInspector();
        WriteObjectInspector writeObjectInspector = new WriteObjectInspector();
        reader.accept((ClassVisitor)readObjectInspector, 0);
        reader.accept((ClassVisitor)writeObjectInspector, 0);
        byte[] classData = pOriginalClassBytes;
        if (readObjectInspector.isInjectionAware() || writeObjectInspector.isInjectionAware()) {
            ClassWriter writer = new ClassWriter(reader, 0);
            SerializableClassVisitor visitor = new ReadObjectMethodClassVisitor((ClassVisitor)writer, readObjectInspector);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new ReadObjectFieldInjectionClassVisitor(readObjectInspector, (ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new WriteObjectMethodClassVisitor((ClassVisitor)writer, writeObjectInspector);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new WriteObjectFieldInjectionClassVisitor(writeObjectInspector, (ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 0);
            classData = writer.toByteArray();
        }
        return classData;
    }
}

