/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.function.Predicate;

public class FieldCollector
extends HashMap<Field, Field> {
    private static final long serialVersionUID = 1L;
    private final Predicate<Field> predicate;

    public FieldCollector(Predicate<Field> pPredicate, Class<?> pSourceType, Class<?> pTargetType) throws NoSuchFieldException, SecurityException {
        this.predicate = pPredicate;
        this.collectDeclaredFields(pSourceType, pTargetType);
    }

    public FieldCollector(Class<?> pSourceType, Class<?> pTargetType) throws NoSuchFieldException, SecurityException {
        this(f -> true, pSourceType, pTargetType);
    }

    private void collectDeclaredFields(Class<?> pSourceType, Class<?> pTargetType) throws NoSuchFieldException, SecurityException {
        if (pSourceType != null) {
            for (Field f : pSourceType.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || !this.predicate.test(f)) continue;
                this.put(f, pTargetType.getDeclaredField(f.getName()));
            }
            this.collectDeclaredFields(pSourceType.getSuperclass(), pTargetType.getSuperclass());
        }
    }
}

