/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.util;

import ch.sourcepond.utils.podescoin.internal.Activator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;

public class PodesCoinClassLoader
extends ClassLoader {
    private static final String[] IGNORED_PACKAGE_PREFIXES = new String[]{"java.", "javax.", "sun."};
    private final Map<String, Class<?>> enhancedClasses = new HashMap();

    public PodesCoinClassLoader() {
        super(ClassLoader.getSystemClassLoader());
    }

    public PodesCoinClassLoader(ClassLoader pParent) {
        super(pParent);
    }

    private static boolean isNonJDKClass(Class<?> pType) {
        boolean allowed;
        boolean bl = allowed = pType != null;
        if (allowed) {
            for (int i = 0; i < IGNORED_PACKAGE_PREFIXES.length; ++i) {
                if (!pType.getName().startsWith(IGNORED_PACKAGE_PREFIXES[i])) continue;
                allowed = false;
                break;
            }
        }
        return allowed;
    }

    protected ClassLoader getParentLoader() {
        ClassLoader parent = super.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Map<String, Class<?>> map = this.enhancedClasses;
        synchronized (map) {
            Class<?> enhancedClass = this.enhancedClasses.get(name);
            if (enhancedClass == null) {
                Class<?> originalClass = this.getParentLoader().loadClass(name);
                if (Serializable.class.isAssignableFrom(originalClass) && PodesCoinClassLoader.isNonJDKClass(originalClass)) {
                    this.enhanceClassHierarchy(originalClass);
                    enhancedClass = this.enhancedClasses.get(name);
                } else {
                    enhancedClass = originalClass;
                    this.enhancedClasses.put(name, originalClass);
                }
            }
            return enhancedClass;
        }
    }

    private void enhanceClassHierarchy(Class<?> pOriginalClass) throws ClassNotFoundException {
        if (pOriginalClass != null && PodesCoinClassLoader.isNonJDKClass(pOriginalClass) && !this.enhancedClasses.containsKey(pOriginalClass.getName())) {
            if (pOriginalClass.isArray()) {
                this.enhanceClassHierarchy(pOriginalClass.getComponentType());
            } else {
                for (Class<?> ifs : pOriginalClass.getInterfaces()) {
                    this.enhanceClassHierarchy(ifs);
                }
                if (!pOriginalClass.isInterface()) {
                    this.enhanceClass(pOriginalClass);
                } else {
                    byte[] classData = PodesCoinClassLoader.toByteArray(pOriginalClass);
                    this.defineClass(pOriginalClass, classData);
                }
            }
            this.enhanceClassHierarchy(pOriginalClass.getSuperclass());
        }
    }

    private static byte[] toByteArray(Class<?> pOriginalClass) throws ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedInputStream in = new BufferedInputStream(pOriginalClass.getResourceAsStream("/" + pOriginalClass.getName().replace('.', '/') + ".class"));){
            byte[] buffer = new byte[1024];
            int read = ((InputStream)in).read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        return out.toByteArray();
    }

    private void enhanceClass(Class<?> pOriginalClass) throws ClassNotFoundException {
        byte[] enhancedClassData = Activator.transform(PodesCoinClassLoader.toByteArray(pOriginalClass));
        try {
            this.defineClass(pOriginalClass, enhancedClassData);
        }
        catch (IllegalAccessError e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void defineClass(Class<?> pOriginalClass, byte[] classData) {
        Class<?> enhancedClass = this.enhancedClasses.get(pOriginalClass.getName());
        if (enhancedClass == null) {
            ProtectionDomain originalProtectionDomain = pOriginalClass.getProtectionDomain();
            enhancedClass = this.defineClass(pOriginalClass.getName(), classData, 0, classData.length, new ProtectionDomain(originalProtectionDomain.getCodeSource(), originalProtectionDomain.getPermissions(), this, originalProtectionDomain.getPrincipals()));
            this.enhancedClasses.put(pOriginalClass.getName(), enhancedClass);
        }
    }
}

