/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.internal.SerializableClassVisitor;
import ch.sourcepond.utils.podescoin.internal.field.ReadObjectFieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.field.WriteObjectFieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.inspector.ReadObjectInspector;
import ch.sourcepond.utils.podescoin.internal.inspector.WriteObjectInspector;
import ch.sourcepond.utils.podescoin.internal.method.ReadObjectMethodClassVisitor;
import ch.sourcepond.utils.podescoin.internal.method.WriteObjectMethodClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class Transformer {
    public static byte[] transform(byte[] pOriginalClassBytes) {
        ClassReader reader = new ClassReader(pOriginalClassBytes);
        ReadObjectInspector readObjectInspector = new ReadObjectInspector();
        WriteObjectInspector writeObjectInspector = new WriteObjectInspector();
        reader.accept((ClassVisitor)readObjectInspector, 0);
        reader.accept((ClassVisitor)writeObjectInspector, 0);
        byte[] classData = pOriginalClassBytes;
        if (readObjectInspector.isInjectionAware() || writeObjectInspector.isInjectionAware()) {
            ClassWriter writer = new ClassWriter(reader, 0);
            SerializableClassVisitor visitor = new ReadObjectMethodClassVisitor((ClassVisitor)writer, readObjectInspector);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new ReadObjectFieldInjectionClassVisitor(readObjectInspector, (ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new WriteObjectMethodClassVisitor((ClassVisitor)writer, writeObjectInspector);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new WriteObjectFieldInjectionClassVisitor(writeObjectInspector, (ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 0);
            classData = writer.toByteArray();
        }
        return classData;
    }
}

