/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.inspector;

import ch.sourcepond.utils.podescoin.internal.AmbiguousInjectorMethodsException;
import ch.sourcepond.utils.podescoin.internal.NamedClassVisitor;
import ch.sourcepond.utils.podescoin.internal.inspector.DefaultStreamCallGenerator;
import ch.sourcepond.utils.podescoin.internal.inspector.InjectorMethodInspector;
import java.lang.annotation.Annotation;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class Inspector
extends NamedClassVisitor {
    private static final String[][] EMPTY = new String[0][0];
    private String[][] components;
    private String injectorMethodName;
    private String injectorMethodDesc;
    private boolean hasStreamArgument;
    private boolean hasStandardMethod;
    private DefaultStreamCallGenerator defaultStreamCallGenerator;

    public Inspector() {
        super(null);
    }

    public boolean isInjectionAware() {
        return this.components != null;
    }

    public boolean hasStandardMethod() {
        return this.hasStandardMethod;
    }

    private MethodVisitor createMethodInspector(MethodVisitor pVisitor, String name, String desc) {
        InjectorMethodInspector injectorMethodVisitor = new InjectorMethodInspector(pVisitor);
        injectorMethodVisitor.setInspector(this);
        injectorMethodVisitor.setClassInternalName(this.classInternalName);
        injectorMethodVisitor.setInjectorMethodAnnotationName(this.getInjectorMethodAnnotation().getName());
        injectorMethodVisitor.setInjectorMethodDesc(desc);
        injectorMethodVisitor.setInjectorMethodName(name);
        injectorMethodVisitor.setObjectStreamClass(this.getObjectStreamClass());
        injectorMethodVisitor.setSuperClassInternalNameOrNull(this.superClassInternalNameOrNull);
        return injectorMethodVisitor;
    }

    protected abstract DefaultStreamCallGenerator createDefaultStreamCallGenerator();

    protected abstract boolean isInjectorMethod(int var1, String var2, String var3, String[] var4);

    protected abstract Class<?> getObjectStreamClass();

    protected abstract Class<? extends Annotation> getInjectorMethodAnnotation();

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (!"<init>".equals(name)) {
            visitor = this.createMethodInspector(visitor, name, desc);
            boolean hasStandardMethod = this.isInjectorMethod(access, name, desc, exceptions);
            if (!this.hasStandardMethod && hasStandardMethod) {
                this.hasStandardMethod = hasStandardMethod;
            }
            if (this.defaultStreamCallGenerator == null && hasStandardMethod) {
                this.defaultStreamCallGenerator = m -> {};
            }
        }
        return visitor;
    }

    final void registerNamedComponent(String pComponentId, int pParameterIndex) {
        this.components[this.hasStreamArgument ? pParameterIndex - 1 : pParameterIndex][0] = pComponentId;
    }

    public final String[][] getComponents() {
        return this.components;
    }

    public final boolean hasObjectInputStream() {
        return this.hasStreamArgument;
    }

    final void initArgumentTypes(boolean pHasObjectInputStream, String pInjectorMethodName, String pInjectorMethodDesc) {
        if (this.components != null) {
            throw new AmbiguousInjectorMethodsException(String.format("More than one method detected which is annotated with %s", this.getInjectorMethodAnnotation().getName()));
        }
        this.hasStreamArgument = pHasObjectInputStream;
        this.injectorMethodName = pInjectorMethodName;
        this.injectorMethodDesc = pInjectorMethodDesc;
        Type[] argumentTypes = Type.getArgumentTypes((String)pInjectorMethodDesc);
        if (this.hasStreamArgument) {
            Type[] reducedArgumentTypes = new Type[argumentTypes.length - 1];
            System.arraycopy(argumentTypes, 1, reducedArgumentTypes, 0, reducedArgumentTypes.length);
            argumentTypes = reducedArgumentTypes;
        }
        if (argumentTypes.length > 0) {
            this.components = new String[argumentTypes.length][2];
            for (int i = 0; i < argumentTypes.length; ++i) {
                this.components[i][1] = argumentTypes[i].getClassName();
            }
        } else {
            this.components = EMPTY;
        }
    }

    public final DefaultStreamCallGenerator getDefaultStreamCallGenerator() {
        if (this.defaultStreamCallGenerator == null) {
            this.defaultStreamCallGenerator = this.createDefaultStreamCallGenerator();
        }
        return this.defaultStreamCallGenerator;
    }

    public final String getInjectorMethodName() {
        return this.injectorMethodName;
    }

    public final String getInjectorMethodDesc() {
        return this.injectorMethodDesc;
    }
}

