/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.api.Component;
import ch.sourcepond.utils.podescoin.api.ReadObject;
import ch.sourcepond.utils.podescoin.api.WriteObject;
import ch.sourcepond.utils.podescoin.internal.SerializableClassVisitor;
import ch.sourcepond.utils.podescoin.internal.field.ReadObjectFieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.field.WriteObjectFieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.inspector.ReadObjectInspector;
import ch.sourcepond.utils.podescoin.internal.inspector.WriteObjectInspector;
import ch.sourcepond.utils.podescoin.internal.method.ReadObjectMethodClassVisitor;
import ch.sourcepond.utils.podescoin.internal.method.WriteObjectMethodClassVisitor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class Transformer {
    private static final String[] IGNORED_PACKAGE_PREFIXES = new String[]{"java.", "javax.", "sun."};

    public static byte[] transform(byte[] pOriginalClassBytes) {
        ClassReader reader = new ClassReader(pOriginalClassBytes);
        ReadObjectInspector readObjectInspector = new ReadObjectInspector();
        WriteObjectInspector writeObjectInspector = new WriteObjectInspector();
        reader.accept((ClassVisitor)readObjectInspector, 0);
        reader.accept((ClassVisitor)writeObjectInspector, 0);
        byte[] classData = pOriginalClassBytes;
        if (readObjectInspector.isInjectionAware() || writeObjectInspector.isInjectionAware()) {
            ClassWriter writer = new ClassWriter(reader, 0);
            SerializableClassVisitor visitor = new ReadObjectMethodClassVisitor((ClassVisitor)writer, readObjectInspector);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new ReadObjectFieldInjectionClassVisitor(readObjectInspector, (ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new WriteObjectMethodClassVisitor((ClassVisitor)writer, writeObjectInspector);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new WriteObjectFieldInjectionClassVisitor(writeObjectInspector, (ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 0);
            classData = writer.toByteArray();
        }
        return classData;
    }

    public static boolean isNonJDKClass(Class<?> pType) {
        boolean allowed;
        boolean bl = allowed = pType != null;
        if (allowed) {
            for (int i = 0; i < IGNORED_PACKAGE_PREFIXES.length; ++i) {
                if (!pType.getName().startsWith(IGNORED_PACKAGE_PREFIXES[i])) continue;
                allowed = false;
                break;
            }
        }
        return allowed;
    }

    private static void collectAccessibleObjects(Class<?> pClass, Collection<AccessibleObject> pAccessibleObjects, Function<Class<?>, AccessibleObject[]> pGetAccessibleObjects) {
        if (pClass != null) {
            for (AccessibleObject o : pGetAccessibleObjects.apply(pClass)) {
                pAccessibleObjects.add(o);
            }
            Transformer.collectAccessibleObjects(pClass.getSuperclass(), pAccessibleObjects, pGetAccessibleObjects);
        }
    }

    public static boolean hasEnhancerAnnotation(Class<?> pClass) {
        if (Serializable.class.isAssignableFrom(pClass) && Transformer.isNonJDKClass(pClass)) {
            LinkedList<AccessibleObject> accessibleObjects = new LinkedList<AccessibleObject>();
            Transformer.collectAccessibleObjects(pClass, accessibleObjects, c -> c.getDeclaredFields());
            Transformer.collectAccessibleObjects(pClass, accessibleObjects, c -> c.getDeclaredMethods());
            for (AccessibleObject obj : accessibleObjects) {
                obj.setAccessible(true);
                if (!obj.isAnnotationPresent(Component.class) && !obj.isAnnotationPresent(ReadObject.class) && !obj.isAnnotationPresent(WriteObject.class)) continue;
                return true;
            }
        }
        return false;
    }
}

