/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci;

import ch.sourcepond.utils.bci.AmbiguousComponentException;
import ch.sourcepond.utils.bci.Container;
import ch.sourcepond.utils.bci.Injector;
import ch.sourcepond.utils.bci.NoSuchComponentException;
import ch.sourcepond.utils.bci.internal.BundleInjector;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;

final class BundleInjectorImpl
implements ServiceListener,
Container,
BundleInjector {
    private final Bundle bundle;
    private final ServiceReference<BlueprintContainer> containerRef;
    private final BlueprintContainer container;

    BundleInjectorImpl(Bundle pBundle) {
        this.bundle = pBundle;
        this.containerRef = this.getContainerRef();
        this.container = (BlueprintContainer)pBundle.getBundleContext().getService(this.containerRef);
    }

    private ServiceReference<BlueprintContainer> getContainerRef() {
        try {
            BundleContext context = this.bundle.getBundleContext();
            Collection refs = context.getServiceReferences(BlueprintContainer.class, String.format("(osgi.blueprint.container.symbolicname=%s)", this.bundle.getSymbolicName()));
            Iterator it = refs.iterator();
            if (!it.hasNext()) {
                throw new IllegalStateException(String.format("No blueprint-container found with id '%s'", this.bundle.getSymbolicName()));
            }
            return (ServiceReference)it.next();
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Map<String, Object> findCandidates(Class<?> pTargetType) throws ClassNotFoundException {
        HashMap<String, Object> candidates = new HashMap<String, Object>();
        for (String componentId : this.container.getComponentIds()) {
            Class type;
            String typeName = null;
            ComponentMetadata metadata = this.container.getComponentMetadata(componentId);
            if (metadata instanceof BeanMetadata) {
                typeName = ((BeanMetadata)metadata).getClassName();
            } else if (metadata instanceof ServiceReferenceMetadata) {
                typeName = ((ServiceReferenceMetadata)metadata).getInterface();
            }
            if (typeName == null || !pTargetType.isAssignableFrom(type = this.bundle.loadClass(typeName))) continue;
            candidates.put(componentId, this.container.getComponentInstance(componentId));
        }
        return candidates;
    }

    private Object getComponent(String pFieldNameOrNull, int pParameterIndex, String pComponentIdOrNull, Class<?> pTargetType) throws ClassNotFoundException {
        Object component;
        if (pComponentIdOrNull == null || pComponentIdOrNull.isEmpty()) {
            Map<String, Object> candidates = this.findCandidates(pTargetType);
            if (candidates.size() > 1) {
                throw new AmbiguousComponentException(pFieldNameOrNull, pParameterIndex, candidates);
            }
            if (candidates.isEmpty()) {
                throw new NoSuchComponentException(pFieldNameOrNull, pParameterIndex, pTargetType);
            }
            component = candidates.values().iterator().next();
        } else {
            component = this.container.getComponentInstance(pComponentIdOrNull);
            if (!pTargetType.isAssignableFrom(component.getClass())) {
                if (pFieldNameOrNull != null) {
                    throw new ClassCastException(String.format("Field '%s' is of type '%s' which is not compatible to component with id '%s' and type '%s'", pFieldNameOrNull, pTargetType.getName(), pComponentIdOrNull, component.getClass().getName()));
                }
                throw new ClassCastException(String.format("Parameter at index %d is of type '%s' which is not compatible to component with id '%s' and type '%s'", pParameterIndex, pTargetType.getName(), pComponentIdOrNull, component.getClass().getName()));
            }
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDeserializedObject(Serializable pObj, String[][] pComponentToFields) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        for (int i = 0; i < pComponentToFields.length; ++i) {
            String[] componentToField = pComponentToFields[i];
            if (componentToField.length != 3) {
                throw new IllegalArgumentException(String.format("Component-to-field mapping array must be of size 3! Illegal size %d", componentToField.length));
            }
            Class<?> cl = pObj.getClass();
            for (int z = 0; z < componentToField.length; ++z) {
                Field field = cl.getDeclaredField(componentToField[0]);
                int modifiers = field.getModifiers();
                if (!Modifier.isTransient(modifiers)) {
                    throw new IllegalArgumentException(String.format("Field '%s' must be transient!", field.getName()));
                }
                if (Modifier.isFinal(modifiers)) {
                    throw new IllegalArgumentException(String.format("Field '%s' cannot be final!", field.getName()));
                }
                try {
                    field.setAccessible(true);
                    field.set(pObj, this.getComponent(field.getName(), 0, componentToField[1], this.bundle.loadClass(componentToField[2])));
                    continue;
                }
                finally {
                    field.setAccessible(false);
                }
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (4 == event.getType() && this.containerRef.equals((Object)event.getServiceReference())) {
            Injector.injectors.remove(this.bundle);
        }
    }

    @Override
    public <T> T getComponentById(String pComponentId, String pExpectedTypeName, int pParameterIndex) {
        try {
            return (T)this.getComponent(null, pParameterIndex, pComponentId, this.bundle.loadClass(pExpectedTypeName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T getComponentByTypeName(String pTypeName, int pParameterIndex) {
        try {
            return (T)this.getComponent(null, pParameterIndex, null, this.bundle.loadClass(pTypeName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

