/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci;

import ch.sourcepond.utils.bci.BundleInjectorFactory;
import ch.sourcepond.utils.bci.Container;
import ch.sourcepond.utils.bci.internal.BundleInjector;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceListener;

public final class Injector {
    static final ConcurrentMap<Bundle, BundleInjector> injectors = new ConcurrentHashMap<Bundle, BundleInjector>();
    static BundleInjectorFactory factory = new BundleInjectorFactory();

    private static final BundleInjector getInjector(Serializable pDeserializedObject) {
        if (pDeserializedObject == null) {
            throw new NullPointerException("Deserialized object cannot be null!");
        }
        Bundle bundle = FrameworkUtil.getBundle(pDeserializedObject.getClass());
        if (bundle == null) {
            throw new IllegalStateException("No OSGi environment detected!");
        }
        BundleInjector injector = (BundleInjector)injectors.get(bundle);
        if (injector == null) {
            injector = factory.newInjector(bundle);
            BundleInjector rc = injectors.putIfAbsent(bundle, injector);
            if (rc != null) {
                injector = rc;
            } else {
                bundle.getBundleContext().addServiceListener((ServiceListener)injector);
            }
        }
        return injector;
    }

    public static Container getContainer(Serializable pDeserializedObject) {
        return Injector.getInjector(pDeserializedObject);
    }

    public static void injectComponents(Serializable deserializedObject, String[][] pComponentToFields) {
        if (pComponentToFields == null) {
            throw new NullPointerException("Component-to-field mapping array cannot be null!");
        }
        if (pComponentToFields.length > 0) {
            try {
                Injector.getInjector(deserializedObject).initDeserializedObject(deserializedObject, pComponentToFields);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }
}

