/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci.internal;

import ch.sourcepond.utils.bci.Injector;
import ch.sourcepond.utils.bci.internal.AmbiguousInjectorMethodsException;
import ch.sourcepond.utils.bci.internal.FieldInjectionClassVisitor;
import ch.sourcepond.utils.bci.internal.InspectForInjectorMethodClassVisitor;
import ch.sourcepond.utils.bci.internal.MethodInjectionClassVisitor;
import ch.sourcepond.utils.bci.internal.SerializableClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

public final class Activator
implements BundleActivator,
WeavingHook {
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.registerService(WeavingHook.class, (Object)this, null);
    }

    public void stop(BundleContext context) throws Exception {
    }

    public void weave(WovenClass wovenClass) {
        if (!this.context.getBundle().equals(wovenClass.getBundleWiring().getBundle()) && 1 == wovenClass.getState()) {
            try {
                ClassReader reader = new ClassReader(wovenClass.getBytes());
                ClassWriter writer = new ClassWriter(reader, 0);
                InspectForInjectorMethodClassVisitor inspector = new InspectForInjectorMethodClassVisitor((ClassVisitor)writer);
                SerializableClassVisitor visitor = new FieldInjectionClassVisitor(inspector);
                try {
                    reader.accept((ClassVisitor)visitor, 0);
                }
                catch (AmbiguousInjectorMethodsException e) {
                    throw new WeavingException(e.getMessage(), (Throwable)e);
                }
                reader = new ClassReader(writer.toByteArray());
                writer = new ClassWriter(reader, 0);
                visitor = new MethodInjectionClassVisitor((ClassVisitor)writer, inspector);
                reader.accept((ClassVisitor)visitor, 0);
                wovenClass.setBytes(writer.toByteArray());
                wovenClass.getDynamicImports().add(Injector.class.getPackage().getName());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

