/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci.internal;

import ch.sourcepond.utils.bci.internal.Constants;
import ch.sourcepond.utils.bci.internal.FieldInjectionClassVisitor;
import ch.sourcepond.utils.bci.internal.NamedAnnotationOnFieldVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

final class ComponentFieldVisitor
extends FieldVisitor {
    private final FieldInjectionClassVisitor classVisitor;
    private final String fieldName;
    private final String fieldType;
    private String componentIdOrNull;
    private boolean inject;

    ComponentFieldVisitor(FieldInjectionClassVisitor pClassVisitor, FieldVisitor pDelegate, String pFieldName, String pFieldType) {
        super(327680, pDelegate);
        this.classVisitor = pClassVisitor;
        this.fieldName = pFieldName;
        this.fieldType = pFieldType;
    }

    void setComponentId(String pComponentId) {
        this.componentIdOrNull = pComponentId;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible) {
            if (Constants.INJECT_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
                this.inject = true;
            }
            if (Constants.NAMED_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
                return new NamedAnnotationOnFieldVisitor(this, this.fv.visitAnnotation(desc, visible));
            }
        }
        return super.visitAnnotation(desc, visible);
    }

    public void visitEnd() {
        if (this.inject) {
            this.classVisitor.addNamedComponent(this.fieldName, this.componentIdOrNull, this.fieldType);
        }
    }
}

