/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci.internal;

import ch.sourcepond.utils.bci.internal.ComponentFieldVisitor;
import ch.sourcepond.utils.bci.internal.Constants;
import ch.sourcepond.utils.bci.internal.SerializableClassVisitor;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class FieldInjectionClassVisitor
extends SerializableClassVisitor {
    private static final String INJECTOR_METHOD_NAME = "injectComponents";
    private static final String INJECTOR_METHOD_DESC = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Serializable.class), Type.getType(String[][].class)});
    private static final String FIRST_DIMENSION_INTERNAL_NAME = Type.getInternalName(String[].class);
    private static final String SECOND_DIMENSION_INTERNAL_NAME = Type.getInternalName(String.class);
    private List<String[]> namedComponents;

    public FieldInjectionClassVisitor(ClassVisitor pWriter) {
        super(pWriter);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x80) != 0 && (access & 0x10) == 0) {
            return new ComponentFieldVisitor(this, this.cv.visitField(access, name, desc, signature, value), name, Type.getType((String)desc).getClassName());
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    protected boolean isEnhancementNecessary() {
        return this.namedComponents != null;
    }

    public void addNamedComponent(String pFieldName, String pComponentIdOrNull, String pTypeName) {
        if (this.namedComponents == null) {
            this.namedComponents = new LinkedList<String[]>();
        }
        this.namedComponents.add(new String[]{pFieldName, pComponentIdOrNull, pTypeName});
    }

    @Override
    protected void enhanceReadObject(MethodVisitor mv) {
        String[][] namedComponentArr = new String[this.namedComponents.size()][2];
        this.namedComponents.toArray((T[])namedComponentArr);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, namedComponentArr.length);
        mv.visitTypeInsn(189, FIRST_DIMENSION_INTERNAL_NAME);
        mv.visitInsn(89);
        for (int idx = 0; idx < namedComponentArr.length; ++idx) {
            this.pushByteConstant(mv, idx);
            mv.visitInsn(6);
            mv.visitTypeInsn(189, SECOND_DIMENSION_INTERNAL_NAME);
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitLdcInsn((Object)namedComponentArr[idx][0]);
            mv.visitInsn(83);
            if (namedComponentArr[idx][1] != null) {
                mv.visitInsn(89);
                mv.visitInsn(4);
                mv.visitLdcInsn((Object)namedComponentArr[idx][1]);
                mv.visitInsn(83);
            }
            mv.visitInsn(89);
            mv.visitInsn(5);
            mv.visitLdcInsn((Object)namedComponentArr[idx][2]);
            mv.visitInsn(83);
            mv.visitInsn(83);
            if (idx >= namedComponentArr.length - 1) continue;
            mv.visitInsn(89);
        }
        mv.visitMethodInsn(184, Constants.INJECTOR_INTERNAL_NAME, INJECTOR_METHOD_NAME, INJECTOR_METHOD_DESC, false);
        mv.visitInsn(177);
        mv.visitMaxs(8, 2);
    }
}

