/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci.internal;

import ch.sourcepond.utils.bci.internal.Constants;
import ch.sourcepond.utils.bci.internal.InspectForInjectorMethodClassVisitor;
import ch.sourcepond.utils.bci.internal.NamedAnnotationOnParameterVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class InjectorMethodVisitor
extends MethodVisitor {
    private final InspectForInjectorMethodClassVisitor classVisitor;
    private final String injectorMethodName;
    private final String injectorMethodDesc;

    public InjectorMethodVisitor(InspectForInjectorMethodClassVisitor pClassVisitor, MethodVisitor mv, String pInjectorMethodName, String pInjectorMethodDesc) {
        super(327680, mv);
        this.classVisitor = pClassVisitor;
        this.injectorMethodName = pInjectorMethodName;
        this.injectorMethodDesc = pInjectorMethodDesc;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible && Constants.INJECT_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
            this.classVisitor.initArgumentTypes(this.injectorMethodName, this.injectorMethodDesc);
        }
        return super.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.classVisitor.isArgumentTypesInitialized() && Constants.NAMED_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
            return new NamedAnnotationOnParameterVisitor(this, super.visitParameterAnnotation(parameter, desc, visible), parameter);
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    void setComponentId(String pComponentId, int pParameterIndex) {
        this.classVisitor.addNamedComponent(pComponentId, pParameterIndex);
    }
}

