/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci.internal;

import ch.sourcepond.utils.bci.internal.AmbiguousInjectorMethodsException;
import ch.sourcepond.utils.bci.internal.Constants;
import ch.sourcepond.utils.bci.internal.InjectorMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class InspectForInjectorMethodClassVisitor
extends ClassVisitor {
    private static final String[][] EMPTY = new String[0][0];
    private String[][] namedComponents;
    private String injectorMethodName;
    private String injectorMethodDesc;

    InspectForInjectorMethodClassVisitor(ClassVisitor pWriter) {
        super(327680, pWriter);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!"<init>".equals(name)) {
            return new InjectorMethodVisitor(this, super.visitMethod(access, name, desc, signature, exceptions), name, desc);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    void addNamedComponent(String pComponentId, int pParameterIndex) {
        this.namedComponents[pParameterIndex][0] = pComponentId;
    }

    boolean isArgumentTypesInitialized() {
        return this.namedComponents != null;
    }

    String[][] getComponents() {
        return this.namedComponents;
    }

    void initArgumentTypes(String pInjectorMethodName, String pInjectorMethodDesc) {
        if (this.isArgumentTypesInitialized()) {
            throw new AmbiguousInjectorMethodsException(String.format("More than one method detected which is annotated with %s", Constants.INJECT_ANNOTATION_NAME));
        }
        this.injectorMethodName = pInjectorMethodName;
        this.injectorMethodDesc = pInjectorMethodDesc;
        Type[] argumentTypes = Type.getArgumentTypes((String)pInjectorMethodDesc);
        if (argumentTypes.length > 0) {
            this.namedComponents = new String[argumentTypes.length][2];
            for (int i = 0; i < argumentTypes.length; ++i) {
                this.namedComponents[i][1] = argumentTypes[i].getClassName();
            }
        } else {
            this.namedComponents = EMPTY;
        }
    }

    public String getInjectorMethodName() {
        return this.injectorMethodName;
    }

    public String getInjectorMethodDesc() {
        return this.injectorMethodDesc;
    }
}

