/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.bci.internal;

import ch.sourcepond.utils.bci.internal.EnhanceReadObjectMethodVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

abstract class SerializableClassVisitor
extends ClassVisitor {
    private static final int _ICONST_0 = 0;
    private static final int _ICONST_1 = 1;
    private static final int _ICONST_2 = 2;
    private static final int _ICONST_3 = 3;
    private static final int _ICONST_4 = 4;
    private static final int _ICONST_5 = 5;
    protected static final String INJECT_BLUEPRINT_COMPONENTS_METHOD_NAME = "_$injectBlueprintComponents";
    protected static final String READ_OBJECT_METHOD_NAME = "readObject";
    protected static final String READ_OBJECT_METHOD_DESC = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(ObjectInputStream.class)});
    protected static final String CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME = Type.getInternalName(ClassNotFoundException.class);
    protected static final String IO_EXCEPTION_INTERNAL_NAME = Type.getInternalName(IOException.class);
    protected static final String[] READ_OBJECT_METHOD_EXCEPTIONS = new String[]{IO_EXCEPTION_INTERNAL_NAME, CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME};
    protected static final String OBJECT_INPUT_STREAM_NAME = ObjectInputStream.class.getName();
    protected static final String VOID_NAME = Void.TYPE.getName();
    protected String thisClassInternalName;
    private boolean hasReadObjectMethod;

    protected SerializableClassVisitor(ClassVisitor pWriter) {
        super(327680, pWriter);
    }

    protected void pushByteConstant(MethodVisitor mv, int idx) {
        switch (idx) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                mv.visitIntInsn(16, idx);
            }
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.thisClassInternalName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isReadObjectMethod(access, name, desc, exceptions) && this.isEnhancementNecessary()) {
            return new EnhanceReadObjectMethodVisitor(this.thisClassInternalName, super.visitMethod(access, name, desc, signature, exceptions));
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    protected abstract boolean isEnhancementNecessary();

    protected abstract void enhanceReadObject(MethodVisitor var1);

    private MethodVisitor createMethodVisitor() {
        if (this.hasReadObjectMethod()) {
            return this.cv.visitMethod(2, INJECT_BLUEPRINT_COMPONENTS_METHOD_NAME, Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[0]), null, null);
        }
        return this.cv.visitMethod(2, READ_OBJECT_METHOD_NAME, READ_OBJECT_METHOD_DESC, null, READ_OBJECT_METHOD_EXCEPTIONS);
    }

    protected boolean hasReadObjectMethod() {
        return this.hasReadObjectMethod;
    }

    public void visitEnd() {
        if (this.isEnhancementNecessary()) {
            this.enhanceReadObject(this.createMethodVisitor());
        }
        super.visitEnd();
    }

    protected boolean isReadObjectMethod(int access, String name, String desc, String[] exceptions) {
        Type returnType;
        if (2 == access && READ_OBJECT_METHOD_NAME.equals(name) && exceptions != null && exceptions.length == 2 && IO_EXCEPTION_INTERNAL_NAME.equals(exceptions[0]) && CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME.equals(exceptions[1]) && VOID_NAME.equals((returnType = Type.getReturnType((String)desc)).getClassName())) {
            boolean b;
            Type[] argumentTypes = Type.getArgumentTypes((String)desc);
            boolean bl = b = argumentTypes.length == 1 && OBJECT_INPUT_STREAM_NAME.equals(argumentTypes[0].getClassName());
            if (b && !this.hasReadObjectMethod) {
                this.hasReadObjectMethod = true;
            }
            return b;
        }
        return false;
    }
}

