/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.internal.Constants;
import ch.sourcepond.utils.podescoin.internal.FieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.NamedAnnotationOnFieldVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ComponentFieldVisitor
extends FieldVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentFieldVisitor.class);
    private final FieldInjectionClassVisitor classVisitor;
    private final String fieldName;
    private final String fieldType;
    private String componentIdOrNull;
    private boolean inject;

    ComponentFieldVisitor(FieldInjectionClassVisitor pClassVisitor, FieldVisitor pDelegate, String pFieldName, String pFieldType) {
        super(327680, pDelegate);
        this.classVisitor = pClassVisitor;
        this.fieldName = pFieldName;
        this.fieldType = pFieldType;
    }

    void setComponentId(String pComponentId) {
        this.componentIdOrNull = pComponentId;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible) {
            if (Constants.INJECT_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
                this.inject = true;
            }
            if (Constants.NAMED_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
                return new NamedAnnotationOnFieldVisitor(this, this.fv.visitAnnotation(desc, visible));
            }
        }
        return super.visitAnnotation(desc, visible);
    }

    public void visitEnd() {
        if (this.inject) {
            LOG.debug("{} : registering injection field {} with id {} and type {}", new Object[]{this.classVisitor.getClassName(), this.fieldName, this.componentIdOrNull, this.fieldType});
            this.classVisitor.addNamedComponent(this.fieldName, this.componentIdOrNull, this.fieldType);
        }
    }
}

