/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.internal.Constants;
import ch.sourcepond.utils.podescoin.internal.InspectForInjectorMethodClassVisitor;
import ch.sourcepond.utils.podescoin.internal.NamedAnnotationOnParameterVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InjectorMethodVisitor
extends MethodVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorMethodVisitor.class);
    private final InspectForInjectorMethodClassVisitor classVisitor;
    private final String injectorMethodName;
    private final String injectorMethodDesc;

    public InjectorMethodVisitor(InspectForInjectorMethodClassVisitor pClassVisitor, MethodVisitor mv, String pInjectorMethodName, String pInjectorMethodDesc) {
        super(327680, mv);
        this.classVisitor = pClassVisitor;
        this.injectorMethodName = pInjectorMethodName;
        this.injectorMethodDesc = pInjectorMethodDesc;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible && Constants.INJECT_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
            LOG.debug("{} : {} : added with descriptor {}", new Object[]{this.classVisitor.getClassName(), this.injectorMethodName, this.injectorMethodDesc});
            this.classVisitor.initArgumentTypes(this.injectorMethodName, this.injectorMethodDesc);
        }
        return super.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.classVisitor.isArgumentTypesInitialized() && Constants.NAMED_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
            return new NamedAnnotationOnParameterVisitor(this, super.visitParameterAnnotation(parameter, desc, visible), parameter);
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    void setComponentId(String pComponentId, int pParameterIndex) {
        LOG.debug("{} : {} : use component-id {} for parameter index {}", new Object[]{this.classVisitor.getClassName(), this.injectorMethodName, pComponentId, pParameterIndex});
        this.classVisitor.addNamedComponent(pComponentId, pParameterIndex);
    }
}

