/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.Container;
import ch.sourcepond.utils.podescoin.internal.Constants;
import ch.sourcepond.utils.podescoin.internal.InspectForInjectorMethodClassVisitor;
import ch.sourcepond.utils.podescoin.internal.SerializableClassVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class MethodInjectionClassVisitor
extends SerializableClassVisitor {
    private static final String CONTAINER_INTERNAL_NAME = Type.getInternalName(Container.class);
    private static final String GET_CONTAINER_METHOD_NAME = "getContainer";
    private static final String GET_CONTAINER_METHOD_DESC = Type.getMethodDescriptor((Type)Type.getType(Container.class), (Type[])new Type[]{Type.getType(Serializable.class)});
    private static final String GET_COMPONENT_BY_ID_NAME = "getComponentById";
    private static final String GET_COMPONENT_BY_ID_DESC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class), Type.getType(Integer.TYPE)});
    private static final String GET_COMPONENT_BY_TYPE_NAME_NAME = "getComponentByTypeName";
    private static final String GET_COMPONENT_BY_TYPE_DESC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Integer.TYPE)});
    private static final String OBJECT_INPUT_STREAM_INTERNAL_NAME = Type.getInternalName(ObjectInputStream.class);
    private static final String EXCEPTION_INTERNAL_NAME = Type.getInternalName(Exception.class);
    private static final String IO_EXCEPTION_INTERNAL_NAME = Type.getInternalName(IOException.class);
    private static final String GET_MESSAGE_NAME = "getMessage";
    private static final String GET_MESSAGE_DESC = Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]);
    private static final String CONSTRUCTOR_DESC = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class), Type.getType(Throwable.class)});
    private static final int MIN_STACK_SIZE = 4;
    private final InspectForInjectorMethodClassVisitor inspector;

    public MethodInjectionClassVisitor(ClassVisitor pVisitor, InspectForInjectorMethodClassVisitor pInspector) {
        super(pVisitor);
        this.inspector = pInspector;
    }

    @Override
    protected boolean isEnhancementNecessary() {
        String[][] components = this.inspector.getComponents();
        return components != null && components.length > 0;
    }

    @Override
    protected void enhanceReadObject(MethodVisitor mv) {
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, EXCEPTION_INTERNAL_NAME);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, Constants.INJECTOR_INTERNAL_NAME, GET_CONTAINER_METHOD_NAME, GET_CONTAINER_METHOD_DESC, false);
        mv.visitVarInsn(58, 2);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        int stackSize = 4;
        if (this.inspector.hasObjectInputStream()) {
            mv.visitVarInsn(25, 1);
            ++stackSize;
        }
        String[][] components = this.inspector.getComponents();
        boolean increaseByOne = false;
        int i = 0;
        while (i < components.length) {
            mv.visitVarInsn(25, 2);
            if (components[i][0] != null) {
                mv.visitLdcInsn((Object)components[i][0]);
                mv.visitLdcInsn((Object)components[i][1]);
                this.pushByteConstant(mv, i);
                mv.visitMethodInsn(185, CONTAINER_INTERNAL_NAME, GET_COMPONENT_BY_ID_NAME, GET_COMPONENT_BY_ID_DESC, true);
                if (!increaseByOne) {
                    increaseByOne = true;
                }
            } else {
                mv.visitLdcInsn((Object)components[i][1]);
                this.pushByteConstant(mv, i);
                mv.visitMethodInsn(185, CONTAINER_INTERNAL_NAME, GET_COMPONENT_BY_TYPE_NAME_NAME, GET_COMPONENT_BY_TYPE_DESC, true);
            }
            mv.visitTypeInsn(192, components[i][1].replace('.', '/'));
            ++i;
            ++stackSize;
        }
        mv.visitMethodInsn(182, this.inspector.getInternalClassName(), this.inspector.getInjectorMethodName(), this.inspector.getInjectorMethodDesc(), false);
        mv.visitLabel(l1);
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitFrame(0, 3, new Object[]{this.inspector.getInternalClassName(), OBJECT_INPUT_STREAM_INTERNAL_NAME, CONTAINER_INTERNAL_NAME}, 1, new Object[]{EXCEPTION_INTERNAL_NAME});
        mv.visitVarInsn(58, 3);
        mv.visitTypeInsn(187, IO_EXCEPTION_INTERNAL_NAME);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, EXCEPTION_INTERNAL_NAME, GET_MESSAGE_NAME, GET_MESSAGE_DESC, false);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, IO_EXCEPTION_INTERNAL_NAME, "<init>", CONSTRUCTOR_DESC, false);
        mv.visitInsn(191);
        mv.visitLabel(l3);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitMaxs(increaseByOne ? stackSize + 1 : stackSize, 4);
        mv.visitEnd();
    }
}

