/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin;

import ch.sourcepond.testing.OptionsHelper;
import ch.sourcepond.utils.podescoin.testbundle.FieldInjectionObject;
import ch.sourcepond.utils.podescoin.testbundle.FieldInjectionObjectWithComponentId;
import ch.sourcepond.utils.podescoin.testbundle.Injected;
import ch.sourcepond.utils.podescoin.testbundle.InjectorMethodObject;
import ch.sourcepond.utils.podescoin.testbundle.InjectorMethodObjectWithComponentId;
import ch.sourcepond.utils.podescoin.testbundle.TestObjectFactory;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;

@RunWith(value=PaxExam.class)
public class WeavingHookTest {
    @Inject
    private TestObjectFactory factory;

    @Configuration
    public Option[] configure() {
        return CoreOptions.options((Option[])new Option[]{CoreOptions.mavenBundle((String)"ch.sourcepond.utils", (String)"podescoin-impl").versionAsInProject(), CoreOptions.mavenBundle((String)"ch.sourcepond.utils", (String)"podescoin-testbundle").versionAsInProject(), CoreOptions.mavenBundle((String)"ch.sourcepond.utils", (String)"podescoin-testservice").versionAsInProject(), OptionsHelper.blueprintBundles(), CoreOptions.junitBundles()});
    }

    private void verifyService(Injected pInjected, String pDateServiceId, String pNameServiceId) {
        Assert.assertNotNull((Object)pInjected.getDateService());
        Assert.assertNotNull((Object)pInjected.getNameService());
        Assert.assertEquals((Object)pDateServiceId, (Object)pInjected.getDateService().getId());
        Assert.assertEquals((Object)pNameServiceId, (Object)pInjected.getNameService().getId());
    }

    @Test
    public void verifyFieldInjection() throws Exception {
        FieldInjectionObject obj = this.factory.getFieldInjectionObject();
        this.verifyService((Injected)obj, "testservice.date", "testservice.name");
    }

    @Test
    public void verifyFieldInjectionWithComponentId() throws Exception {
        FieldInjectionObjectWithComponentId obj = this.factory.getFieldInjectionObjectWithComponentId();
        this.verifyService((Injected)obj, "testservice.ambiguousDate2", "testservice.ambiguousName1");
    }

    @Test
    public void verifyInjectorMethod() throws Exception {
        InjectorMethodObject obj = this.factory.getInjectorMethodObject();
        this.verifyService((Injected)obj, "testservice.date", "testservice.name");
    }

    @Test
    public void verifyInjectorMethodWithComponentId() throws Exception {
        InjectorMethodObjectWithComponentId obj = this.factory.getInjectorMethodObjectWithComponentId();
        this.verifyService((Injected)obj, "testservice.ambiguousDate2", "testservice.ambiguousName1");
    }
}

