/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin;

import ch.sourcepond.utils.podescoin.BundleDetector;
import ch.sourcepond.utils.podescoin.EnhancedClassLoader;
import ch.sourcepond.utils.podescoin.EnhancedObjectInputStream;
import ch.sourcepond.utils.podescoin.Injector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import sun.misc.Unsafe;

public class CloneContext {
    private static final EnhancedClassLoader loader = new EnhancedClassLoader(CloneContext.class.getClassLoader());
    private static final Unsafe UNSAFE;
    private static final String TEST_BUNDLE_SYMBOLIC_NAME = "PodesCoinTestBundleInjector";
    private final BundleDetector detector = (BundleDetector)Mockito.mock(BundleDetector.class);
    private final Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
    private final BundleContext bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
    private final BlueprintContainer blueprintContainer = (BlueprintContainer)Mockito.mock(BlueprintContainer.class);
    private final ServiceReference<BlueprintContainer> blueprintContainerRef = (ServiceReference)Mockito.mock(ServiceReference.class);
    private final Collection<ServiceReference<BlueprintContainer>> blueprintContainerRefs = Arrays.asList(this.blueprintContainerRef);
    private final Set<String> componentIds = new HashSet<String>();

    protected CloneContext() {
        Injector.detector = this.detector;
        Mockito.when((Object)this.detector.getBundle((Class)Mockito.any())).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.bundle.getSymbolicName()).thenReturn((Object)TEST_BUNDLE_SYMBOLIC_NAME);
        Mockito.when((Object)this.bundle.getBundleContext()).thenReturn((Object)this.bundleContext);
        try {
            Mockito.when((Object)this.bundleContext.getServiceReferences(BlueprintContainer.class, String.format("(osgi.blueprint.container.symbolicname=%s)", TEST_BUNDLE_SYMBOLIC_NAME))).thenReturn(this.blueprintContainerRefs);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        Mockito.when((Object)this.bundleContext.getService(this.blueprintContainerRef)).thenReturn((Object)this.blueprintContainer);
        Mockito.when((Object)this.blueprintContainer.getComponentIds()).thenReturn(this.componentIds);
    }

    private CloneContext addComponentMetadata(Object pComponent, String componentId, Class<?> pType) {
        this.componentIds.add(componentId);
        BeanMetadata meta = (BeanMetadata)Mockito.mock(BeanMetadata.class);
        Mockito.when((Object)meta.getClassName()).thenReturn((Object)pType.getName());
        try {
            Mockito.when((Object)this.bundle.loadClass(pType.getName())).thenReturn(pType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Mockito.when((Object)this.blueprintContainer.getComponentMetadata(componentId)).thenReturn((Object)meta);
        Mockito.when((Object)this.blueprintContainer.getComponentInstance(componentId)).thenReturn(pComponent);
        return this;
    }

    public <T> CloneContext addComponent(T pComponent, Class<T> pType) {
        String componentId = UUID.randomUUID().toString();
        return this.addComponentMetadata(pComponent, componentId, pType);
    }

    public <T> CloneContext addComponent(T pComponent, String pComponentId, Class<T> pType) {
        return this.addComponentMetadata(pComponent, pComponentId, pType);
    }

    private boolean hasRegisteredType(Collection<Object> pCollection) throws ClassNotFoundException {
        for (Object o : pCollection) {
            if (o == null || !loader.isRegistered(o.getClass())) continue;
            return true;
        }
        return false;
    }

    private Object copyState(Class<?> pOriginalClass, Class<?> pEnhancedClass, Object pOriginal, Object pEnhancedClone) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (pOriginalClass != null) {
            for (Field originalField : pOriginalClass.getDeclaredFields()) {
                Object original;
                if (Modifier.isStatic(originalField.getModifiers())) continue;
                Field enhancedField = pEnhancedClass.getDeclaredField(originalField.getName());
                originalField.setAccessible(true);
                enhancedField.setAccessible(true);
                Object valueFromEnhancedObject = enhancedField.get(pEnhancedClone);
                if (valueFromEnhancedObject instanceof Collection && !(original = (Collection)valueFromEnhancedObject).isEmpty() && this.hasRegisteredType((Collection<Object>)original)) {
                    ArrayList clonedCollection = new ArrayList((Collection)valueFromEnhancedObject);
                    original.clear();
                    for (Object e : clonedCollection) {
                        if (e == null) continue;
                        Class<?> originalClass = loader.getOriginalClass(e.getClass());
                        original.add(this.copyState(originalClass, e.getClass(), UNSAFE.allocateInstance(originalClass), e));
                    }
                }
                if (valueFromEnhancedObject instanceof Map && !(original = (Map)valueFromEnhancedObject).isEmpty() && (this.hasRegisteredType(original.keySet()) || this.hasRegisteredType(original.values()))) {
                    HashMap clone = new HashMap(original);
                    original.clear();
                    for (Map.Entry entry : clone.entrySet()) {
                        Object value;
                        Object key = entry.getKey();
                        if (loader.isRegistered(key.getClass())) {
                            Class<?> originalKeyClass = loader.getOriginalClass(key.getClass());
                            key = this.copyState(originalKeyClass, key.getClass(), UNSAFE.allocateInstance(originalKeyClass), key);
                        }
                        if (loader.isRegistered((value = entry.getValue()).getClass())) {
                            Class<?> originalValueClass = loader.getOriginalClass(value.getClass());
                            key = this.copyState(originalValueClass, key.getClass(), UNSAFE.allocateInstance(originalValueClass), key);
                        }
                        original.put(key, value);
                    }
                }
                if (loader.isRegistered(originalField.getType())) {
                    originalField.set(pOriginal, this.copyState(originalField.getType(), enhancedField.getType(), UNSAFE.allocateInstance(originalField.getType()), valueFromEnhancedObject));
                    continue;
                }
                originalField.set(pOriginal, valueFromEnhancedObject);
            }
            return this.copyState(pOriginalClass.getSuperclass(), pEnhancedClass.getSuperclass(), pOriginal, pEnhancedClone);
        }
        return pOriginal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> T deepClone(T obj) throws IOException, ClassNotFoundException {
        loader.register(obj.getClass());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oout = new ObjectOutputStream(out);){
            oout.writeObject(obj);
        }
        try {
            var4_5 = null;
            try (EnhancedObjectInputStream in = new EnhancedObjectInputStream(loader, new ByteArrayInputStream(out.toByteArray()));){
                Object deserialized = in.readObject();
                Serializable serializable = (Serializable)this.copyState(obj.getClass(), deserialized.getClass(), UNSAFE.allocateInstance(obj.getClass()), deserialized);
                return (T)serializable;
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    static {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            UNSAFE = (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception e) {
            throw new Error(e.getMessage(), e);
        }
    }
}

