/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin;

import ch.sourcepond.utils.podescoin.internal.Activator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;

final class EnhancedClassLoader
extends ClassLoader {
    private final Map<Class<?>, Class<?>> enhancedClasses = new HashMap();
    private final Map<Class<?>, Class<?>> originalClasses = new HashMap();

    EnhancedClassLoader(ClassLoader pParent) {
        super(pParent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cl = this.enhancedClasses.get(name);
        if (cl == null) {
            cl = super.findClass(name);
        } else {
            System.out.println(cl);
        }
        return cl;
    }

    private <T extends AccessibleObject> boolean hasAnnotation(Class<?> pClass, Function<Class<?>, T[]> pFunc, Predicate<AnnotatedElement> pTester) {
        if (pClass != null) {
            for (AccessibleObject member : (AccessibleObject[])pFunc.apply(pClass)) {
                if (!pTester.test(member)) continue;
                return true;
            }
            return this.hasAnnotation(pClass.getSuperclass(), pFunc, pTester);
        }
        return false;
    }

    private Class<?>[] determineTypeParameterClass(Type pGenericType) throws ClassNotFoundException {
        Type[] actualTypeArguments;
        Class[] result = null;
        if (pGenericType != null && pGenericType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)pGenericType).getActualTypeArguments()).length > 0) {
            result = new Class[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                try {
                    result[i] = this.getClass().getClassLoader().loadClass(actualTypeArguments[i].getTypeName());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    result[i] = Object.class;
                }
            }
        }
        if (result == null) {
            result = new Class[]{};
        }
        return result;
    }

    private Class<?> enhanceClass(Class<?> pClass) throws ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream("/" + pClass.getName().replace('.', '/') + ".class"));){
            byte[] buffer = new byte[1024];
            int read = ((InputStream)in).read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        byte[] enhancedClassData = Activator.transform((byte[])out.toByteArray());
        return this.defineClass(pClass.getName(), enhancedClassData, 0, enhancedClassData.length, this.getClass().getProtectionDomain());
    }

    private void register(Class<?> pClass, Field pField, Set<Class<?>> pVisitedClasses) throws ClassNotFoundException {
        if (pClass != null && !pVisitedClasses.contains(pClass) && !this.enhancedClasses.containsKey(pClass)) {
            pVisitedClasses.add(pClass);
            if (pClass.isArray()) {
                this.register(pClass.getComponentType(), null, pVisitedClasses);
            } else if (Collection.class.isAssignableFrom(pClass) || Map.class.isAssignableFrom(pClass)) {
                for (AnnotatedElement annotatedElement : this.determineTypeParameterClass(pField.getGenericType())) {
                    this.register((Class<?>)annotatedElement, null, pVisitedClasses);
                }
            } else {
                Predicate<AnnotatedElement> tester = e -> e.isAnnotationPresent(Inject.class);
                if (this.hasAnnotation(pClass, cl -> cl.getDeclaredFields(), tester) || this.hasAnnotation(pClass, cl -> cl.getDeclaredMethods(), tester)) {
                    Class<?> enhancedClass = this.enhanceClass(pClass);
                    this.enhancedClasses.put(pClass, enhancedClass);
                    this.originalClasses.put(enhancedClass, pClass);
                }
            }
            for (AnnotatedElement annotatedElement : pClass.getDeclaredFields()) {
                this.register(((Field)annotatedElement).getType(), (Field)annotatedElement, pVisitedClasses);
            }
            this.register(pClass.getSuperclass(), pField, pVisitedClasses);
        }
    }

    public Class<?> getOriginalClass(Class<?> pEnhancedClass) throws ClassNotFoundException {
        return this.originalClasses.get(pEnhancedClass);
    }

    public boolean isRegistered(Class<?> pClass) throws ClassNotFoundException {
        return this.originalClasses.containsKey(pClass);
    }

    public void register(Class<?> pClass) throws ClassNotFoundException {
        this.register(pClass, null, new HashSet());
    }
}

