/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.testing;

import ch.sourcepond.utils.podescoin.testing.TestingClassLoader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;

final class Cloner {
    private static final Unsafe UNSAFE;
    private final Set<Object> visited = new HashSet<Object>();
    private final TestingClassLoader loader;

    public Cloner(TestingClassLoader pLoader) {
        this.loader = pLoader;
    }

    private Map<Field, Field> getDeclaredFields(Class<?> pSourceType, Class<?> pTargetType, Map<Field, Field> pCollectedFields) throws NoSuchFieldException, SecurityException {
        if (pSourceType != null) {
            for (Field f : pSourceType.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                pCollectedFields.put(f, pTargetType.getDeclaredField(f.getName()));
            }
            return this.getDeclaredFields(pSourceType.getSuperclass(), pTargetType.getSuperclass(), pCollectedFields);
        }
        return pCollectedFields;
    }

    private Map<Field, Field> getDeclaredFields(Class<?> pSourceType, Class<?> pTargetType) throws NoSuchFieldException, SecurityException {
        return this.getDeclaredFields(pSourceType, pTargetType, new LinkedHashMap<Field, Field>());
    }

    private Object copyState(Class<?> pSourceType, Class<?> pTargetType, Object pSource, Object pTarget) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        for (Map.Entry<Field, Field> fieldEntry : this.getDeclaredFields(pSourceType, pTargetType).entrySet()) {
            Field sourceField = fieldEntry.getKey();
            sourceField.setAccessible(true);
            Object sourceValue = sourceField.get(pSource);
            Object targetValue = null;
            if (!sourceField.getType().isPrimitive() && sourceValue != null) {
                Class<?> targetType = null;
                Class<?> sourceType = sourceValue.getClass();
                if (sourceType.isArray()) {
                    int size = Array.getLength(sourceValue);
                    sourceType = sourceType.getComponentType();
                    if (size > 0 && !sourceType.isPrimitive()) {
                        targetType = this.loader.getOriginalClass(sourceType);
                        if (targetType == null) {
                            targetType = sourceType;
                        }
                        targetValue = Array.newInstance(targetType, size);
                        for (int i = 0; i < size; ++i) {
                            Object sourceElementValue = Array.get(sourceValue, i);
                            if (sourceElementValue == null) continue;
                            sourceType = sourceElementValue.getClass();
                            Object targetElementValue = sourceType.equals(targetType = this.loader.getOriginalClass(sourceType)) ? sourceElementValue : this.copyState(sourceType, targetType, sourceElementValue, UNSAFE.allocateInstance(targetType));
                            Array.set(targetValue, i, targetElementValue);
                        }
                    }
                } else if (!this.visited.contains(sourceValue)) {
                    this.visited.add(sourceValue);
                    targetType = this.loader.getOriginalClass(sourceType);
                    targetValue = sourceType.equals(targetType) ? this.copyState(sourceType, sourceType, sourceValue, sourceValue) : this.copyState(sourceType, targetType, sourceValue, UNSAFE.allocateInstance(targetType));
                }
            }
            if (targetValue == null) {
                targetValue = sourceValue;
            }
            Field targetField = fieldEntry.getValue();
            targetField.setAccessible(true);
            targetField.set(pTarget, targetValue);
        }
        return pTarget;
    }

    public Object copyState(Object pSource) throws Exception {
        Class<?> targetType = this.loader.getOriginalClass(pSource.getClass());
        return this.copyState(pSource.getClass(), targetType, pSource, UNSAFE.allocateInstance(targetType));
    }

    static {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            UNSAFE = (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception e) {
            throw new Error(e.getMessage(), e);
        }
    }
}

