/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.testing;

import ch.sourcepond.utils.podescoin.Injector;
import ch.sourcepond.utils.podescoin.testing.PodesCoinTestingContext;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Named;

public class PodesCoinTestingContextFactory {
    private static final Object ORIGINAL_DETECTOR;
    static final Class<?> BUNDLE_DETECTOR_INTERFACE;
    static final Method GET_BUNDLE_METHOD;
    static final String OSGI_BLUEPRINT_CONTAINER_SYMBOLICNAME_FILTER;
    static final Field DETECTOR_FIELD;

    public static PodesCoinTestingContext newContext() {
        try {
            return new PodesCoinTestingContext();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new AssertionError(String.format("Instance of %s could not be created!", PodesCoinTestingContext.class.getName()), e);
        }
    }

    private static List<Field> collectFields(Class<?> pClassOrNull, List<Field> pFields) {
        if (pClassOrNull != null) {
            for (Field f : pClassOrNull.getDeclaredFields()) {
                if (!f.isAnnotationPresent(Named.class)) continue;
                f.setAccessible(true);
                pFields.add(f);
            }
            return PodesCoinTestingContextFactory.collectFields(pClassOrNull.getSuperclass(), pFields);
        }
        return pFields;
    }

    public static PodesCoinTestingContext newContext(Object pTest) {
        PodesCoinTestingContext context = PodesCoinTestingContextFactory.newContext();
        for (Field f : PodesCoinTestingContextFactory.collectFields(pTest.getClass(), new LinkedList<Field>())) {
            Named component = f.getAnnotation(Named.class);
            try {
                context.addComponent(f.get(pTest), component.value(), f.getType());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return context;
    }

    static void setDetector(Object detector) {
        try {
            DETECTOR_FIELD.set(Injector.class, detector);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError(String.format("Field '%s' could not be set on %s", DETECTOR_FIELD.getName(), Injector.class.getName()), e);
        }
    }

    static void resetDetector() {
        PodesCoinTestingContextFactory.setDetector(ORIGINAL_DETECTOR);
    }

    static {
        try {
            ClassLoader ldr = PodesCoinTestingContextFactory.class.getClassLoader();
            BUNDLE_DETECTOR_INTERFACE = ldr.loadClass("ch.sourcepond.utils.podescoin.BundleDetector");
            GET_BUNDLE_METHOD = BUNDLE_DETECTOR_INTERFACE.getMethod("getBundle", Class.class);
            GET_BUNDLE_METHOD.setAccessible(true);
            Class<?> bundleInjectorImpl = ldr.loadClass("ch.sourcepond.utils.podescoin.BundleInjectorImpl");
            Field osgiBlueprintContainerSymbolicnameFilter = bundleInjectorImpl.getDeclaredField("OSGI_BLUEPRINT_CONTAINER_SYMBOLICNAME_FILTER");
            osgiBlueprintContainerSymbolicnameFilter.setAccessible(true);
            OSGI_BLUEPRINT_CONTAINER_SYMBOLICNAME_FILTER = (String)osgiBlueprintContainerSymbolicnameFilter.get(bundleInjectorImpl);
            DETECTOR_FIELD = Injector.class.getDeclaredField("detector");
            DETECTOR_FIELD.setAccessible(true);
            ORIGINAL_DETECTOR = DETECTOR_FIELD.get(Injector.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new AssertionError(String.format("Class %s could not be initialized", PodesCoinTestingContextFactory.class.getName()), e);
        }
    }
}

