/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin;

import ch.sourcepond.testing.OptionsHelper;
import ch.sourcepond.utils.podescoin.api.Component;
import ch.sourcepond.utils.podescoin.testbundle.ExtendedFieldInjectionObjectWithComponentId;
import ch.sourcepond.utils.podescoin.testbundle.FieldInjectionObject;
import ch.sourcepond.utils.podescoin.testbundle.FieldInjectionObjectWithComponentId;
import ch.sourcepond.utils.podescoin.testbundle.Injected;
import ch.sourcepond.utils.podescoin.testbundle.InjectorMethodObject;
import ch.sourcepond.utils.podescoin.testbundle.InjectorMethodObjectWithComponentId;
import ch.sourcepond.utils.podescoin.testbundle.TestObjectFactory;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;

@RunWith(value=PaxExam.class)
public class WeavingHookTest {
    @Inject
    private TestObjectFactory factory;

    @Configuration
    public Option[] configure() {
        Component.class.getName();
        return CoreOptions.options((Option[])new Option[]{CoreOptions.mavenBundle((String)"ch.sourcepond.utils", (String)"podescoin-api").versionAsInProject(), CoreOptions.mavenBundle((String)"ch.sourcepond.utils", (String)"podescoin-core").versionAsInProject(), CoreOptions.mavenBundle((String)"ch.sourcepond.utils", (String)"podescoin-testbundle").versionAsInProject(), CoreOptions.mavenBundle((String)"ch.sourcepond.utils", (String)"podescoin-testservice").versionAsInProject(), CoreOptions.mavenBundle((String)"org.ops4j.pax.tinybundles", (String)"tinybundles").versionAsInProject(), CoreOptions.mavenBundle((String)"biz.aQute.bnd", (String)"bndlib").versionAsInProject(), OptionsHelper.blueprintBundles(), CoreOptions.junitBundles()});
    }

    private void verifyService(Injected pInjected, String pDateServiceId, String pNameServiceId) {
        Assert.assertNotNull((Object)pInjected.getDateService());
        Assert.assertNotNull((Object)pInjected.getNameService());
        Assert.assertEquals((Object)pDateServiceId, (Object)pInjected.getDateService().getId());
        Assert.assertEquals((Object)pNameServiceId, (Object)pInjected.getNameService().getId());
    }

    @Test
    public void verifyUnserializableObject() throws Exception {
        this.factory.getUnserializableObject();
    }

    @Test
    public void verifyFieldInjection() throws Exception {
        FieldInjectionObject obj = this.factory.getFieldInjectionObject();
        this.verifyService((Injected)obj, "testservice.date", "testservice.name");
    }

    @Test
    public void verifyFieldInjectionWithComponentId() throws Exception {
        FieldInjectionObjectWithComponentId obj = this.factory.getFieldInjectionObjectWithComponentId();
        this.verifyService((Injected)obj, "testservice.ambiguousDate2", "testservice.ambiguousName1");
    }

    @Test
    public void verifyExtendedFieldInjectionWithComponentId() throws Exception {
        ExtendedFieldInjectionObjectWithComponentId obj = this.factory.getExtendedFieldInjectionObjectWithComponentId();
        this.verifyService((Injected)obj, "testservice.ambiguousDate2", "testservice.ambiguousName1");
        Assert.assertSame((Object)obj.getNameService(), (Object)obj.getExtendedNameService());
    }

    @Test
    public void verifyInjectorMethod() throws Exception {
        InjectorMethodObject obj = this.factory.getInjectorMethodObject();
        Assert.assertEquals((Object)"test_testservice.date", (Object)obj.getTransferredDateServiceId());
        Assert.assertEquals((Object)"test_testservice.name", (Object)obj.getTransferredNameServiceId());
        this.verifyService((Injected)obj, "testservice.date", "testservice.name");
    }

    @Test
    public void verifyInjectorMethodWithComponentId() throws Exception {
        InjectorMethodObjectWithComponentId obj = this.factory.getInjectorMethodObjectWithComponentId();
        Assert.assertEquals((Object)"test_testservice.ambiguousDate2", (Object)obj.getTransferredDateServiceId());
        Assert.assertEquals((Object)"test_testservice.ambiguousName1", (Object)obj.getTransferredNameServiceId());
        this.verifyService((Injected)obj, "testservice.ambiguousDate2", "testservice.ambiguousName1");
    }
}

