/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.comm.rpc.OnRpcInvocation;
import ch.squaredesk.nova.comm.rpc.RpcRequestHandlerDescription;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

class BeanExaminer {
    BeanExaminer() {
    }

    RpcRequestHandlerDescription[] examine(Object bean) {
        Objects.requireNonNull(bean, "bean to examine must not be null");
        Method[] methods = bean.getClass().getDeclaredMethods();
        return (RpcRequestHandlerDescription[])Arrays.stream(methods).filter(m -> m.isAnnotationPresent(OnRpcInvocation.class)).map(m -> {
            OnRpcInvocation annotation = m.getAnnotation(OnRpcInvocation.class);
            this.ensureProperRpcHandlerFunction(annotation.value(), bean, (Method)m);
            return new RpcRequestHandlerDescription(annotation.value(), bean, (Method)m);
        }).toArray(RpcRequestHandlerDescription[]::new);
    }

    private void ensureProperRpcHandlerFunction(Class<?> registeredRequestTypeClass, Object bean, Method m) {
        if (!Modifier.isPublic(m.getModifiers())) {
            throw new IllegalArgumentException("Annotated RPC request handler method " + BeanExaminer.prettyPrint(bean, m) + " must be public");
        }
        if (m.getReturnType().equals(Void.TYPE) || m.getReturnType().equals(Void.class)) {
            throw new IllegalArgumentException("Annotated RPC request handler method " + BeanExaminer.prettyPrint(bean, m) + " must be a function RequestType -> ReplyType");
        }
        if (m.getParameterCount() != 1) {
            throw new IllegalArgumentException("Annotated RPC request handler method " + BeanExaminer.prettyPrint(bean, m) + " must be a function RequestType -> ReplyType");
        }
        Class<?> requestClass = m.getParameterTypes()[0];
        if (!registeredRequestTypeClass.isAssignableFrom(requestClass)) {
            throw new IllegalArgumentException("Parameter type of annotated RPC request handler method " + BeanExaminer.prettyPrint(bean, m) + " must be " + registeredRequestTypeClass.getName() + " or a subclass");
        }
    }

    private static String prettyPrint(Object bean, Method method) {
        StringBuilder sb = new StringBuilder(bean.getClass().getName()).append('.').append(method.getName()).append('(').append(Arrays.stream(method.getParameterTypes()).map(paramterClass -> paramterClass.getSimpleName()).collect(Collectors.joining(", "))).append(')');
        return sb.toString();
    }
}

