/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.comm.rpc.RpcInvocation;
import ch.squaredesk.nova.tuples.Pair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcRequestProcessor<RpcInvocationType extends RpcInvocation<IncomingMessageType, ?, ReturnMessageType, ?>, IncomingMessageType, ReturnMessageType>
implements io.reactivex.functions.Function<RpcInvocationType, Pair<RpcInvocationType, ReturnMessageType>> {
    private static final Logger logger = LoggerFactory.getLogger(RpcRequestProcessor.class);
    private final Map<Class<?>, io.reactivex.functions.Function<IncomingMessageType, ReturnMessageType>> handlerFunctions = new ConcurrentHashMap();
    private Function<IncomingMessageType, ReturnMessageType> onMissingHandler;
    private BiFunction<IncomingMessageType, Throwable, ReturnMessageType> onProcessingException;

    public void register(Class<?> requestClass, io.reactivex.functions.Function<IncomingMessageType, ReturnMessageType> handlerFunction) {
        if (this.handlerFunctions.containsKey(requestClass)) {
            throw new IllegalArgumentException("Handler for request type " + requestClass.getName() + " already registered");
        }
        this.handlerFunctions.put(requestClass, handlerFunction);
    }

    public Pair<RpcInvocationType, ReturnMessageType> apply(RpcInvocationType rpcInvocation) throws Exception {
        io.reactivex.functions.Function<IncomingMessageType, ReturnMessageType> handlerFunction = this.handlerFunctions.get(((RpcInvocation)rpcInvocation).request.getClass());
        Object reply = null;
        if (handlerFunction == null) {
            if (this.onMissingHandler != null) {
                reply = this.onMissingHandler.apply(((RpcInvocation)rpcInvocation).request);
            } else if (this.onProcessingException != null) {
                reply = this.onProcessingException.apply(((RpcInvocation)rpcInvocation).request, new IllegalArgumentException("Requests of type " + ((RpcInvocation)rpcInvocation).request.getClass().getSimpleName() + " are not supported"));
            } else {
                logger.error("No handler found to process incoming request " + rpcInvocation);
            }
        } else {
            try {
                reply = handlerFunction.apply(((RpcInvocation)rpcInvocation).request);
            }
            catch (Throwable t) {
                if (this.onProcessingException != null) {
                    reply = this.onProcessingException.apply(((RpcInvocation)rpcInvocation).request, t);
                }
                logger.error("An error occurred, trying to process incoming request " + rpcInvocation, t);
            }
        }
        return new Pair(rpcInvocation, reply);
    }

    public void onMissingRequestProcessor(Function<IncomingMessageType, ReturnMessageType> function) {
        this.onMissingHandler = function;
    }

    public void onProcessingException(BiFunction<IncomingMessageType, Throwable, ReturnMessageType> function) {
        this.onProcessingException = function;
    }
}

