/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.comm.rpc.RpcInvocation;
import ch.squaredesk.nova.comm.rpc.RpcServerMetricsCollector;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcRequestProcessor<MessageType, RpcInvocationType extends RpcInvocation<? extends MessageType, ?, ? extends MessageType, ?>>
implements Consumer<RpcInvocationType> {
    private static final Logger logger = LoggerFactory.getLogger(RpcRequestProcessor.class);
    private final Map<Class<?>, BiConsumer<? extends MessageType, RpcInvocationType>> handlerFunctions = new ConcurrentHashMap();
    private final RpcServerMetricsCollector metricsCollector;
    private java.util.function.Consumer<RpcInvocationType> unregisteredRequestHandler = invocation -> {
        logger.error("No handler found to process incoming request " + invocation);
        invocation.completeExceptionally((Throwable)new RuntimeException("Invalid request"));
    };
    private java.util.function.BiConsumer<RpcInvocationType, Throwable> uncaughtExceptionHandler = (invocation, error) -> {
        logger.error("An error occurred, trying to process incoming request " + invocation, error);
        invocation.completeExceptionally((Throwable)new RuntimeException("Invalid request"));
    };

    public RpcRequestProcessor(Metrics metrics) {
        Objects.requireNonNull(metrics, "Metrics must not be null");
        this.metricsCollector = new RpcServerMetricsCollector(null, metrics);
    }

    public void register(Class<?> requestClass, BiConsumer<? extends MessageType, RpcInvocationType> handlerFunction) {
        if (this.handlerFunctions.containsKey(requestClass)) {
            throw new IllegalArgumentException("Handler for request type " + requestClass.getName() + " already registered");
        }
        this.handlerFunctions.put(requestClass, handlerFunction);
    }

    public void accept(RpcInvocationType rpcInvocation) {
        try {
            BiConsumer<? extends MessageType, RpcInvocationType> handlerFunction = null;
            if (((RpcInvocation)rpcInvocation).request != null && ((RpcInvocation)rpcInvocation).request.message != null) {
                handlerFunction = this.handlerFunctions.get(((RpcInvocation)rpcInvocation).request.message.getClass());
            }
            if (handlerFunction == null) {
                this.unregisteredRequestHandler.accept(rpcInvocation);
            } else {
                this.metricsCollector.requestReceived((Object)((RpcInvocation)rpcInvocation).request);
                Object request = ((RpcInvocation)rpcInvocation).request.message;
                this.metricsCollector.requestCompleted((Object)((RpcInvocation)rpcInvocation).request, null);
                handlerFunction.accept(request, rpcInvocation);
            }
        }
        catch (Throwable t) {
            this.metricsCollector.requestCompletedExceptionally((Object)((RpcInvocation)rpcInvocation).request, t);
            this.uncaughtExceptionHandler.accept(rpcInvocation, t);
        }
    }

    public void onUnregisteredRequest(java.util.function.Consumer<RpcInvocationType> function) {
        Objects.requireNonNull(function, "handler for unregistered requests must not be null");
        this.unregisteredRequestHandler = function;
    }

    public void onProcessingException(java.util.function.BiConsumer<RpcInvocationType, Throwable> function) {
        Objects.requireNonNull(function, "handler for processing errors must not be null");
        this.uncaughtExceptionHandler = function;
    }
}

