/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.comm.rpc.OnRpcInvocation;
import ch.squaredesk.nova.comm.rpc.RpcCompletor;
import ch.squaredesk.nova.comm.rpc.RpcRequestHandlerDescription;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

class BeanExaminer {
    BeanExaminer() {
    }

    RpcRequestHandlerDescription[] examine(Object bean) {
        Objects.requireNonNull(bean, "bean to examine must not be null");
        Method[] methods = bean.getClass().getDeclaredMethods();
        return (RpcRequestHandlerDescription[])Arrays.stream(methods).filter(m -> m.isAnnotationPresent(OnRpcInvocation.class)).map(m -> {
            OnRpcInvocation annotation = m.getAnnotation(OnRpcInvocation.class);
            BeanExaminer.ensureProperRpcHandlerFunction(annotation.value(), bean, m);
            return new RpcRequestHandlerDescription(annotation.value(), bean, (Method)m);
        }).toArray(RpcRequestHandlerDescription[]::new);
    }

    private static boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    private static boolean returnsVoid(Method m) {
        return m.getReturnType().equals(Void.TYPE) || m.getReturnType().equals(Void.class);
    }

    private static boolean acceptsTwoParameters(Method m) {
        return m.getParameterCount() == 2;
    }

    private static boolean isRpcCompletor(Class<?> classToTest) {
        return RpcCompletor.class.isAssignableFrom(classToTest);
    }

    private static boolean parameterOneHasType(Method m, Class<?> typeToVerify) {
        Class<?> parameterType = m.getParameterTypes()[0];
        return parameterType.isAssignableFrom(typeToVerify);
    }

    private static boolean parameterTwoIsRpcCompletor(Method m) {
        Class<?> parameterType = m.getParameterTypes()[1];
        return BeanExaminer.isRpcCompletor(parameterType);
    }

    private static void ensureProperRpcHandlerFunction(Class<?> requestTypeClass, Object bean, Method m) {
        if (!BeanExaminer.isPublic(m)) {
            throw new IllegalArgumentException("Annotated RPC request handler method " + BeanExaminer.prettyPrint(bean, m) + " must be public");
        }
        if (!(BeanExaminer.returnsVoid(m) && BeanExaminer.acceptsTwoParameters(m) && BeanExaminer.parameterOneHasType(m, requestTypeClass) && BeanExaminer.parameterTwoIsRpcCompletor(m))) {
            throw new IllegalArgumentException("Annotated RPC request handler method " + BeanExaminer.prettyPrint(bean, m) + " must be a BiConsumer<" + requestTypeClass.getSimpleName() + ", RpcCompletor>");
        }
    }

    private static String prettyPrint(Object bean, Method method) {
        return bean.getClass().getName() + '.' + method.getName() + '(' + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ')';
    }
}

