/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Class<?> getConcreteTypeOfGenericInterfaceImplementation(Object instanceToExamine, Class<?> implementedInterfaceClass, int parameterIndex) {
        Type[] actualTypes;
        Type genericInterfaceType = Arrays.stream(instanceToExamine.getClass().getGenericInterfaces()).filter(t -> t.getTypeName().contains(implementedInterfaceClass.getName())).findFirst().get();
        if (genericInterfaceType instanceof ParameterizedType && (actualTypes = ((ParameterizedType)genericInterfaceType).getActualTypeArguments()).length >= parameterIndex) {
            return (Class)actualTypes[parameterIndex];
        }
        return null;
    }

    public static Class<?> getConcreteTypeOfGenericClassExtension(Class<?> classToExamine, int parameterIndex) {
        Type[] actualTypes;
        Type genericSuperclassType = classToExamine.getGenericSuperclass();
        if (genericSuperclassType instanceof ParameterizedType && (actualTypes = ((ParameterizedType)genericSuperclassType).getActualTypeArguments()).length >= parameterIndex) {
            return (Class)actualTypes[parameterIndex];
        }
        return null;
    }

    public static Object instanceFromClassName(String className) {
        Class<?> classObject;
        try {
            classObject = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + className, e);
        }
        try {
            return classObject.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate class " + className, e);
        }
    }
}

