/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.metrics.Metrics;
import com.codahale.metrics.Meter;

public class RpcClientMetricsCollector {
    private final Metrics metrics;
    private final String identifierPrefix;
    private final Meter totalNumberOfCompletedRequests;
    private final Meter totalNumberOfTimedOutRequests;

    RpcClientMetricsCollector(String identifier, Metrics metrics) {
        this.metrics = metrics;
        this.identifierPrefix = Metrics.name((String)"rpcClient", (String[])new String[]{identifier});
        this.totalNumberOfCompletedRequests = metrics.getMeter(this.identifierPrefix, new String[]{"completed", "total"});
        this.totalNumberOfTimedOutRequests = metrics.getMeter(this.identifierPrefix, new String[]{"timeout", "total"});
    }

    public void rpcCompleted(Object request, Object reply) {
        String id = request == null ? "null" : request.getClass().getSimpleName();
        Meter specificMeter = this.metrics.getMeter(this.identifierPrefix, new String[]{"completed", id});
        this.mark(specificMeter, this.totalNumberOfCompletedRequests);
    }

    public void rpcTimedOut(Object request) {
        String id = request == null ? "null" : request.getClass().getSimpleName();
        Meter specificMeter = this.metrics.getMeter(this.identifierPrefix, new String[]{"timeout", id});
        this.mark(specificMeter, this.totalNumberOfTimedOutRequests);
    }

    private void mark(Meter ... meters) {
        for (Meter m : meters) {
            m.mark();
        }
    }
}

