/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.metrics.Metrics;
import com.codahale.metrics.Meter;

public class RpcServerMetricsCollector {
    private final Metrics metrics;
    private final String identifierPrefix;
    private final Meter totalNumberOfReceivedRequests;
    private final Meter totalNumberOfCompletedRequests;
    private final Meter totalNumberOfErrorRequests;

    RpcServerMetricsCollector(String identifier, Metrics metrics) {
        this.metrics = metrics;
        this.identifierPrefix = Metrics.name((String)"rpcServer", (String[])new String[]{identifier});
        this.totalNumberOfReceivedRequests = metrics.getMeter(this.identifierPrefix, new String[]{"requests", "total"});
        this.totalNumberOfCompletedRequests = metrics.getMeter(this.identifierPrefix, new String[]{"completed", "total"});
        this.totalNumberOfErrorRequests = metrics.getMeter(this.identifierPrefix, new String[]{"error", "total"});
    }

    public void requestReceived(Object request) {
        String id = request == null ? "null" : request.getClass().getSimpleName();
        Meter specificMeter = this.metrics.getMeter(this.identifierPrefix, new String[]{"requests", id});
        this.mark(specificMeter, this.totalNumberOfReceivedRequests);
    }

    public void requestCompleted(Object request, Object reply) {
        String id = request == null ? "null" : request.getClass().getSimpleName();
        Meter specificMeter = this.metrics.getMeter(this.identifierPrefix, new String[]{"completed", id});
        this.mark(specificMeter, this.totalNumberOfCompletedRequests);
    }

    public void requestCompletedExceptionally(Object request, Throwable error) {
        String id = request == null ? "null" : request.getClass().getSimpleName();
        Meter specificMeter = this.metrics.getMeter(this.identifierPrefix, new String[]{"error", id});
        this.mark(specificMeter, this.totalNumberOfErrorRequests);
    }

    private void mark(Meter ... meters) {
        for (Meter m : meters) {
            m.mark();
        }
    }
}

