/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm;

import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class DefaultMarshallerFactory {
    private DefaultMarshallerFactory() {
    }

    public static <MessageType> MessageMarshaller<MessageType, String> getMarshallerForMessageType(Class<MessageType> messageType) {
        if (messageType.equals(Object.class)) {
            throw new IllegalArgumentException("default marshaller for class java.lang.Object is not supported");
        }
        if (String.class.isAssignableFrom(messageType)) {
            return object -> object == null ? null : String.valueOf(object);
        }
        if (Integer.class.isAssignableFrom(messageType)) {
            return String::valueOf;
        }
        if (Long.class.isAssignableFrom(messageType)) {
            return String::valueOf;
        }
        if (Double.class.isAssignableFrom(messageType)) {
            return String::valueOf;
        }
        if (BigDecimal.class.isAssignableFrom(messageType)) {
            return String::valueOf;
        }
        Object objectMapper = DefaultMarshallerFactory.instantiateObjectMapperViaReflection();
        if (objectMapper == null) {
            throw new IllegalArgumentException("Unable to create default marshaller for message type " + messageType);
        }
        Method marshallingMethod = DefaultMarshallerFactory.getMarshallingMethod(objectMapper);
        return o -> {
            try {
                return (String)marshallingMethod.invoke(objectMapper, o);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to marshal outgoing message " + o, e);
            }
        };
    }

    public static MessageUnmarshaller<String, ?> getUnmarshallerForMessageType(Class<?> messageType) {
        if (messageType.equals(Object.class)) {
            throw new IllegalArgumentException("default unmarshaller for class java.lang.Object is not supported");
        }
        if (String.class.isAssignableFrom(messageType)) {
            return s -> s;
        }
        if (Integer.class.isAssignableFrom(messageType)) {
            return Integer::parseInt;
        }
        if (Long.class.isAssignableFrom(messageType)) {
            return Long::parseLong;
        }
        if (Double.class.isAssignableFrom(messageType)) {
            return Double::parseDouble;
        }
        if (BigDecimal.class.isAssignableFrom(messageType)) {
            return BigDecimal::new;
        }
        Object objectMapper = DefaultMarshallerFactory.instantiateObjectMapperViaReflection();
        if (objectMapper == null) {
            throw new IllegalArgumentException("Unable to create default unmarshaller for message type " + messageType);
        }
        Method unmarshallingMethod = DefaultMarshallerFactory.getUnmarshallingMethod(objectMapper);
        return s -> {
            try {
                return unmarshallingMethod.invoke(objectMapper, s, messageType);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to unmarshal incoming message '" + s + "'", e);
            }
        };
    }

    private static Object instantiateObjectMapperViaReflection() {
        try {
            Class<?> objectMapperClass = Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            Object objectMapper = objectMapperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> deserializationFeatureClass = Class.forName("com.fasterxml.jackson.databind.DeserializationFeature");
            Object deserializationFeature = Enum.valueOf(deserializationFeatureClass, "FAIL_ON_UNKNOWN_PROPERTIES");
            Method serializationConfigMethod = objectMapperClass.getMethod("configure", deserializationFeatureClass, Boolean.TYPE);
            serializationConfigMethod.invoke(objectMapper, deserializationFeature, false);
            Method findAndRegisterModulesMethod = objectMapperClass.getMethod("findAndRegisterModules", new Class[0]);
            findAndRegisterModulesMethod.invoke(objectMapper, new Object[0]);
            return objectMapper;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Method getMarshallingMethod(Object objectMapper) {
        try {
            return objectMapper.getClass().getMethod("writeValueAsString", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find unmarshalling method in ObjectMapper", e);
        }
    }

    private static Method getUnmarshallingMethod(Object objectMapper) {
        try {
            return objectMapper.getClass().getMethod("readValue", String.class, Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find unmarshalling method in ObjectMapper", e);
        }
    }
}

