/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.comm.retrieving.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.rpc.RpcCompletor;
import ch.squaredesk.nova.tuples.Pair;
import java.util.function.Consumer;

public class RpcInvocation<RequestType, IncomingMetaDataType extends IncomingMessageMetaData<?, ?>, ReplyType, TransportSpecificReplyInfo>
implements RpcCompletor<ReplyType, TransportSpecificReplyInfo> {
    public final IncomingMessage<RequestType, IncomingMetaDataType> request;
    private final Consumer<Pair<ReplyType, TransportSpecificReplyInfo>> replyConsumer;
    private final Consumer<Throwable> errorConsumer;

    public RpcInvocation(IncomingMessage<RequestType, IncomingMetaDataType> request, Consumer<Pair<ReplyType, TransportSpecificReplyInfo>> replyConsumer, Consumer<Throwable> errorConsumer) {
        this.request = request;
        this.replyConsumer = replyConsumer;
        this.errorConsumer = errorConsumer;
    }

    @Override
    public void complete(ReplyType reply, TransportSpecificReplyInfo replySpecificInfo) {
        this.replyConsumer.accept(new Pair(reply, replySpecificInfo));
    }

    @Override
    public void completeExceptionally(Throwable error) {
        this.errorConsumer.accept(error);
    }

    public String toString() {
        return "{ request=" + this.request + '}';
    }
}

