/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.sending;

import ch.squaredesk.nova.metrics.Metrics;
import io.dropwizard.metrics5.Meter;
import java.util.Objects;

class MetricsCollector {
    private final Metrics metrics;
    private final String identifierPrefix;
    private final Meter totalNumberOfSentMessages;

    MetricsCollector(String identifier, Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.metrics = metrics;
        this.identifierPrefix = Metrics.name((String)"messageSender", (String[])new String[]{identifier}).toString();
        this.totalNumberOfSentMessages = metrics.getMeter(this.identifierPrefix, new String[]{"sent", "total"});
    }

    public void messageSent(Object destination) {
        this.metrics.getMeter(this.identifierPrefix, new String[]{"sent", String.valueOf(destination)}).mark();
        this.totalNumberOfSentMessages.mark();
    }
}

