/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm;

import ch.squaredesk.nova.comm.retrieving.IncomingMessageTranscriber;
import ch.squaredesk.nova.comm.sending.OutgoingMessageTranscriber;
import io.reactivex.functions.Function;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageTranscriber<TransportMessageType> {
    private Map<Class<?>, Function<?, TransportMessageType>> specificOutgoingTranscribers = new ConcurrentHashMap();
    private Map<Class<?>, Function<TransportMessageType, ?>> specificIncomingTranscribers = new ConcurrentHashMap();
    private OutgoingMessageTranscriber<TransportMessageType> defaultOutgoingMessageTranscriber;
    private IncomingMessageTranscriber<TransportMessageType> defaultIncomingMessageTranscriber;

    public MessageTranscriber(OutgoingMessageTranscriber<TransportMessageType> defaultOutgoingMessageTranscriber, IncomingMessageTranscriber<TransportMessageType> defaultIncomingMessageTranscriber) {
        this.defaultIncomingMessageTranscriber = defaultIncomingMessageTranscriber;
        this.defaultOutgoingMessageTranscriber = defaultOutgoingMessageTranscriber;
    }

    public <T> Function<T, TransportMessageType> getOutgoingMessageTranscriber(T anObject) {
        if (anObject == null) {
            return null;
        }
        Class<?> specificType = anObject.getClass();
        return this.getOutgoingMessageTranscriber(specificType);
    }

    public <T> Function<T, TransportMessageType> getOutgoingMessageTranscriber(Class<T> typeToMarshal) {
        return this.getSpecificOutgoingTranscriber(typeToMarshal);
    }

    public <T> Function<TransportMessageType, T> getIncomingMessageTranscriber(Class<T> typeToUnmarshalTo) {
        return this.getSpecificIncomingTranscriber(typeToUnmarshalTo);
    }

    protected <T> Function<T, TransportMessageType> createDefaultOutgoingMessageTranscriberFor(Class<T> typeToMarshal) {
        if (this.defaultOutgoingMessageTranscriber != null) {
            return this.defaultOutgoingMessageTranscriber.castToFunction(typeToMarshal);
        }
        throw new IllegalArgumentException("Unable to create an OutgingMessageTranscriber for class " + typeToMarshal);
    }

    protected <T> Function<TransportMessageType, T> createDefaultIncomingMessageTranscriberFor(Class<T> typeToUnmarshalTo) {
        if (this.defaultIncomingMessageTranscriber != null) {
            return this.defaultIncomingMessageTranscriber.castToFunction(typeToUnmarshalTo);
        }
        throw new IllegalArgumentException("Unable to create an IncomingMessageTranscriber for class " + typeToUnmarshalTo);
    }

    private <T> Function<T, TransportMessageType> getSpecificOutgoingTranscriber(Class<T> targetClass) {
        return this.specificOutgoingTranscribers.computeIfAbsent(targetClass, theClass -> this.createDefaultOutgoingMessageTranscriberFor((Class)theClass));
    }

    private <T> Function<TransportMessageType, T> getSpecificIncomingTranscriber(Class<T> targetClass) {
        return this.specificIncomingTranscribers.computeIfAbsent(targetClass, theClass -> this.createDefaultIncomingMessageTranscriberFor((Class)theClass));
    }

    public <T> void registerClassSpecificTranscribers(Class<T> targetClass, Function<T, TransportMessageType> outgoingMessageTranscriber, Function<TransportMessageType, T> incomingMessageTranscriber) {
        if (targetClass.equals(Object.class)) {
            throw new IllegalArgumentException("unmarshaller for class java.lang.Object is not supported");
        }
        if (incomingMessageTranscriber == null) {
            this.specificIncomingTranscribers.remove(targetClass);
        } else {
            this.specificIncomingTranscribers.put(targetClass, incomingMessageTranscriber);
        }
        if (outgoingMessageTranscriber == null) {
            this.specificOutgoingTranscribers.remove(targetClass);
        } else {
            this.specificOutgoingTranscribers.put(targetClass, outgoingMessageTranscriber);
        }
    }
}

