/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.sending;

import ch.squaredesk.nova.comm.sending.MetricsCollector;
import ch.squaredesk.nova.comm.sending.OutgoingMessageMetaData;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Completable;
import io.reactivex.functions.Function;
import java.util.Objects;

public abstract class MessageSender<DestinationType, TransportMessageType, MetaDataType extends OutgoingMessageMetaData<DestinationType, ?>> {
    protected final MetricsCollector metricsCollector;

    protected MessageSender(Metrics metrics) {
        this(null, metrics);
    }

    protected MessageSender(String identifier, Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.metricsCollector = new MetricsCollector(identifier, metrics);
    }

    public abstract Completable send(TransportMessageType var1, MetaDataType var2);

    public <T> Completable send(T message, MetaDataType metaData, Function<T, TransportMessageType> transcriber) {
        Object transportMessage = null;
        try {
            transportMessage = transcriber.apply(message);
        }
        catch (Exception e) {
            return Completable.error((Throwable)e);
        }
        return this.send(transportMessage, metaData);
    }
}

