/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm;

import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.retrieving.IncomingMessageTranscriber;
import ch.squaredesk.nova.comm.sending.OutgoingMessageTranscriber;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class DefaultMessageTranscriberForStringAsTransportType
extends MessageTranscriber<String> {
    private static final Object objectMapper = DefaultMessageTranscriberForStringAsTransportType.instantiateObjectMapperViaReflection();

    public DefaultMessageTranscriberForStringAsTransportType() {
        super(DefaultMessageTranscriberForStringAsTransportType.getDefaultOutgoingMessageTranscriber(), DefaultMessageTranscriberForStringAsTransportType.getDefaultIncomingMessageTranscriber());
        this.registerClassSpecificTranscribers(String.class, s -> s, s -> s);
        this.registerClassSpecificTranscribers(Integer.class, String::valueOf, Integer::parseInt);
        this.registerClassSpecificTranscribers(Long.class, String::valueOf, Long::parseLong);
        this.registerClassSpecificTranscribers(Double.class, String::valueOf, Double::parseDouble);
        this.registerClassSpecificTranscribers(BigDecimal.class, String::valueOf, BigDecimal::new);
    }

    private static OutgoingMessageTranscriber<String> getDefaultOutgoingMessageTranscriber() {
        OutgoingMessageTranscriber<String> returnValue = null;
        if (objectMapper != null) {
            final Method marshallingMethodUsingObjectMapper = DefaultMessageTranscriberForStringAsTransportType.getMarshallingMethod(objectMapper);
            returnValue = new OutgoingMessageTranscriber<String>(){

                @Override
                public <U> String transcribeOutgoingMessage(U anObject) throws Exception {
                    return (String)marshallingMethodUsingObjectMapper.invoke(objectMapper, anObject);
                }
            };
        }
        return returnValue;
    }

    private static IncomingMessageTranscriber<String> getDefaultIncomingMessageTranscriber() {
        IncomingMessageTranscriber<String> returnValue = null;
        if (objectMapper != null) {
            final Method unmarshallingMethod = DefaultMessageTranscriberForStringAsTransportType.getUnmarshallingMethod(objectMapper);
            returnValue = new IncomingMessageTranscriber<String>(){

                @Override
                public <U> U transcribeIncomingMessage(String anObject, Class<U> typeToUnmarshalTo) throws Exception {
                    return (U)unmarshallingMethod.invoke(objectMapper, anObject, typeToUnmarshalTo);
                }
            };
        }
        return returnValue;
    }

    private static Object instantiateObjectMapperViaReflection() {
        try {
            Class<?> objectMapperClass = Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            Object objectMapper = objectMapperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> deserializationFeatureClass = Class.forName("com.fasterxml.jackson.databind.DeserializationFeature");
            Object deserializationFeature = Enum.valueOf(deserializationFeatureClass, "FAIL_ON_UNKNOWN_PROPERTIES");
            Method serializationConfigMethod = objectMapperClass.getMethod("configure", deserializationFeatureClass, Boolean.TYPE);
            serializationConfigMethod.invoke(objectMapper, deserializationFeature, false);
            Method findAndRegisterModulesMethod = objectMapperClass.getMethod("findAndRegisterModules", new Class[0]);
            findAndRegisterModulesMethod.invoke(objectMapper, new Object[0]);
            return objectMapper;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Method getMarshallingMethod(Object objectMapper) {
        try {
            return objectMapper.getClass().getMethod("writeValueAsString", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find unmarshalling method in ObjectMapper", e);
        }
    }

    private static Method getUnmarshallingMethod(Object objectMapper) {
        try {
            return objectMapper.getClass().getMethod("readValue", String.class, Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find unmarshalling method in ObjectMapper", e);
        }
    }
}

