/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.retrieving;

import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.comm.retrieving.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.retrieving.MetricsCollector;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.Objects;

public abstract class MessageReceiver<DestinationType, TransportMessageType, MetaDataType extends IncomingMessageMetaData<DestinationType, ?>> {
    protected final MetricsCollector metricsCollector;

    protected MessageReceiver(Metrics metrics) {
        this(null, metrics);
    }

    protected MessageReceiver(String identifier, Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.metricsCollector = new MetricsCollector(identifier, metrics);
    }

    public abstract Flowable<IncomingMessage<TransportMessageType, MetaDataType>> messages(DestinationType var1);

    public <T> Flowable<IncomingMessage<T, MetaDataType>> messages(DestinationType destination, Function<TransportMessageType, T> unmarshaller) {
        return this.messages(destination).map(rawMessage -> {
            Object message = null;
            try {
                message = unmarshaller.apply(rawMessage.message);
            }
            catch (Exception e) {
                this.metricsCollector.unparsableMessageReceived(((IncomingMessageMetaData)rawMessage.metaData).destination);
            }
            return new IncomingMessage(message, rawMessage.metaData);
        }).filter(im -> im.message != null);
    }
}

