/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.retrieving;

import ch.squaredesk.nova.metrics.Metrics;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Meter;
import java.util.Objects;

public class MetricsCollector {
    private final Metrics metrics;
    private final String identifierPrefix;
    private final Meter totalNumberOfReceivedMessages;
    private final Counter totalNumberOfSubscriptions;
    private final Counter totalNumberOfUnparsableMessages;

    MetricsCollector(String identifier, Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.metrics = metrics;
        this.identifierPrefix = Metrics.name((String)"messageReceiver", (String[])new String[]{identifier}).toString();
        this.totalNumberOfReceivedMessages = metrics.getMeter(this.identifierPrefix, new String[]{"received", "total"});
        this.totalNumberOfSubscriptions = metrics.getCounter(this.identifierPrefix, new String[]{"subscriptions", "total"});
        this.totalNumberOfUnparsableMessages = metrics.getCounter(this.identifierPrefix, new String[]{"unparsable", "total"});
    }

    public void unparsableMessageReceived(Object destination) {
        this.metrics.getCounter(this.identifierPrefix, new String[]{"unparsable", String.valueOf(destination)}).inc();
        this.totalNumberOfUnparsableMessages.inc();
    }

    public void messageReceived(Object destination) {
        this.metrics.getMeter(this.identifierPrefix, new String[]{"received", String.valueOf(destination)}).mark();
        this.totalNumberOfReceivedMessages.mark();
    }

    public void subscriptionCreated(Object destination) {
        this.metrics.getCounter(this.identifierPrefix, new String[]{"subscriptions", String.valueOf(destination)}).inc();
        this.totalNumberOfSubscriptions.inc();
    }

    public void subscriptionDestroyed(Object destination) {
        this.metrics.getCounter(this.identifierPrefix, new String[]{"subscriptions", String.valueOf(destination)}).dec();
        this.totalNumberOfSubscriptions.dec();
    }
}

