/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rpc;

import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.comm.retrieving.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.rpc.RpcCompletor;
import ch.squaredesk.nova.tuples.Pair;
import io.reactivex.functions.Function;
import java.util.function.Consumer;

public class RpcInvocation<RequestType, IncomingMetaDataType extends IncomingMessageMetaData<?, ?>, TransportMessageType, TransportSpecificReplyInfo>
implements RpcCompletor<TransportMessageType, TransportSpecificReplyInfo> {
    public final IncomingMessage<RequestType, IncomingMetaDataType> request;
    private final Consumer<Pair<TransportMessageType, TransportSpecificReplyInfo>> replyConsumer;
    private final Consumer<Throwable> errorConsumer;

    public RpcInvocation(IncomingMessage<RequestType, IncomingMetaDataType> request, Consumer<Pair<TransportMessageType, TransportSpecificReplyInfo>> replyConsumer, Consumer<Throwable> errorConsumer) {
        this.request = request;
        this.replyConsumer = replyConsumer;
        this.errorConsumer = errorConsumer;
    }

    @Override
    public <T> void complete(T reply, TransportSpecificReplyInfo replySpecificInfo, Function<T, TransportMessageType> transcriber) throws Exception {
        this.replyConsumer.accept(new Pair(transcriber.apply(reply), replySpecificInfo));
    }

    @Override
    public <T> void complete(T reply, Function<T, TransportMessageType> transcriber) throws Exception {
        this.replyConsumer.accept(new Pair(transcriber.apply(reply), null));
    }

    public void complete(TransportMessageType reply, TransportSpecificReplyInfo replySpecificInfo) {
        this.replyConsumer.accept(new Pair(reply, replySpecificInfo));
    }

    @Override
    public void completeExceptionally(Throwable error) {
        this.errorConsumer.accept(error);
    }

    public String toString() {
        return "{ request=" + this.request + '}';
    }
}

