/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.events;

import ch.squaredesk.nova.events.EventBusConfig;
import ch.squaredesk.nova.events.EventMetricsCollector;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus {
    private final Logger logger = LoggerFactory.getLogger(EventBus.class);
    public final EventBusConfig eventBusConfig;
    private final EventMetricsCollector metricsCollector;
    private final ConcurrentHashMap<Object, Subject<Object[]>> eventSpecificSubjects;

    public EventBus(String identifier, EventBusConfig eventBusConfig, Metrics metrics) {
        this.eventBusConfig = eventBusConfig;
        this.metricsCollector = new EventMetricsCollector(identifier, metrics);
        this.logger.debug("Instantiating event loop {} using the following config {}", (Object)identifier, (Object)eventBusConfig);
        this.eventSpecificSubjects = new ConcurrentHashMap();
    }

    private Subject<Object[]> getSubjectFor(Object event) {
        return this.eventSpecificSubjects.computeIfAbsent(event, key -> {
            this.metricsCollector.eventSubjectAdded(event);
            PublishSubject eventSpecificSubject = PublishSubject.create();
            return eventSpecificSubject.toSerialized();
        });
    }

    public void emit(Object event, Object ... data) {
        Objects.requireNonNull(event, "event must not be null");
        try {
            Subject<Object[]> subject = this.getSubjectFor(event);
            if (!subject.hasObservers()) {
                this.metricsCollector.eventEmittedButNoObservers(event);
                if (this.eventBusConfig.warnOnUnhandledEvents) {
                    this.logger.warn("Trying to dispatch event {}, but no observers could be found. Data: {}", event, (Object)Arrays.toString(data));
                }
            } else {
                subject.onNext((Object)data);
                this.metricsCollector.eventDispatched(event);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to emit event " + event + " with parameters " + Arrays.toString(data), (Throwable)e);
        }
    }

    public Flowable<Object[]> on(Object event) {
        return this.on(event, this.eventBusConfig.defaultBackpressureStrategy);
    }

    public Flowable<Object[]> on(Object event, BackpressureStrategy backpressureStrategy) {
        Objects.requireNonNull(event, "event must not be null");
        return this.getSubjectFor(event).toFlowable(backpressureStrategy);
    }
}

