/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.metrics;

import ch.squaredesk.nova.metrics.CompoundMetric;
import com.codahale.metrics.MetricRegistry;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GarbageCollectionMeter
implements CompoundMetric {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final List<GarbageCollectorMXBean> garbageCollectors;

    public GarbageCollectionMeter() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    public GarbageCollectionMeter(Collection<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = new ArrayList<GarbageCollectorMXBean>(garbageCollectors);
    }

    @Override
    public Map<String, Object> getValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (GarbageCollectorMXBean gc : this.garbageCollectors) {
            String name = WHITESPACE.matcher(gc.getName()).replaceAll("-");
            values.put(MetricRegistry.name((String)name, (String[])new String[]{"count"}), gc.getCollectionCount());
            values.put(MetricRegistry.name((String)name, (String[])new String[]{"time"}), gc.getCollectionTime());
        }
        return values;
    }
}

