/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova;

import ch.squaredesk.nova.events.EventBus;
import ch.squaredesk.nova.events.EventBusConfig;
import ch.squaredesk.nova.filesystem.Filesystem;
import ch.squaredesk.nova.metrics.CpuMeter;
import ch.squaredesk.nova.metrics.GarbageCollectionMeter;
import ch.squaredesk.nova.metrics.MemoryMeter;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.BackpressureStrategy;

public class Nova {
    public final String identifier;
    public final EventBus eventBus;
    public final Filesystem filesystem;
    public final Metrics metrics;

    private Nova(Builder builder) {
        this.metrics = builder.metrics;
        this.identifier = builder.identifier;
        this.eventBus = new EventBus(this.identifier, builder.eventBusConfig, this.metrics);
        this.filesystem = new Filesystem();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String identifier = "";
        private Metrics metrics;
        private boolean captureJvmMetrics = true;
        private BackpressureStrategy defaultBackpressureStrategy = BackpressureStrategy.BUFFER;
        private boolean warnOnUnhandledEvent = false;
        private EventBusConfig eventBusConfig;

        private Builder() {
        }

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setDefaultBackpressureStrategy(BackpressureStrategy defaultBackpressureStrategy) {
            this.defaultBackpressureStrategy = defaultBackpressureStrategy;
            return this;
        }

        public Builder setWarnOnUnhandledEvent(boolean warnOnUnhandledEvent) {
            this.warnOnUnhandledEvent = warnOnUnhandledEvent;
            return this;
        }

        public Builder captureJvmMetrics(boolean captureJvmMetrics) {
            this.captureJvmMetrics = captureJvmMetrics;
            return this;
        }

        public Nova build() {
            if (this.metrics == null) {
                this.metrics = new Metrics();
            }
            if (this.captureJvmMetrics) {
                this.metrics.register(new MemoryMeter(), "jvm", "mem");
                this.metrics.register(new GarbageCollectionMeter(), "jvm", "gc");
                CpuMeter cpuMeter = new CpuMeter();
                if (cpuMeter.environmentSupportsCpuMetrics()) {
                    this.metrics.register(cpuMeter, "os", "cpu");
                }
            }
            this.eventBusConfig = new EventBusConfig(this.defaultBackpressureStrategy, this.warnOnUnhandledEvent);
            return new Nova(this);
        }
    }
}

