/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.events;

import ch.squaredesk.nova.metrics.Metrics;
import com.codahale.metrics.Meter;
import java.util.concurrent.ConcurrentHashMap;

public class EventMetricsCollector {
    private final Metrics metrics;
    private final String identifierPrefix;
    private final Meter allDispatchedEvents;
    private final ConcurrentHashMap<Object, Meter> eventSpecificDispatchMeters;

    public EventMetricsCollector(Metrics metrics) {
        this(null, metrics);
    }

    public EventMetricsCollector(String identifier, Metrics metrics) {
        this.metrics = metrics;
        this.eventSpecificDispatchMeters = new ConcurrentHashMap();
        this.identifierPrefix = Metrics.name("eventBus", identifier);
        this.allDispatchedEvents = new Meter();
        metrics.register(this.allDispatchedEvents, this.identifierPrefix, "dispatchedEvents", "total");
    }

    public void eventDispatched(Object event) {
        this.eventSpecificDispatchMeters.computeIfAbsent(event, key -> {
            Meter meter = new Meter();
            this.metrics.register(meter, this.identifierPrefix, "dispatchedEvents", String.valueOf(key));
            return meter;
        }).mark();
        this.allDispatchedEvents.mark();
    }

    public void eventSubjectAdded(Object event) {
        this.metrics.getCounter(this.identifierPrefix, "eventSubjects", "total").inc();
    }

    public void eventSubjectRemoved(Object event) {
        this.metrics.getCounter(this.identifierPrefix, "eventSubjects", "total").dec();
    }

    public void eventEmittedButNoObservers(Object event) {
        String eventString = String.valueOf(event);
        this.metrics.getCounter(this.identifierPrefix, "emitsWithNoListener", eventString).inc();
        this.metrics.getCounter(this.identifierPrefix, "emitsWithNoListener", "total").inc();
    }
}

