/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.metrics;

import ch.squaredesk.nova.metrics.MetricsDump;
import ch.squaredesk.nova.metrics.SettableGauge;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import io.reactivex.Observable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class Metrics {
    public final MetricRegistry metricRegistry = new MetricRegistry();
    private Slf4jReporter logReporter;

    public MetricsDump dump() {
        return new MetricsDump(this.metricRegistry.getMetrics());
    }

    public Observable<MetricsDump> dumpContinuously(long interval, TimeUnit timeUnit) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        Objects.requireNonNull(timeUnit, "timeUnit must not be null");
        return Observable.interval((long)interval, (long)interval, (TimeUnit)timeUnit).map(count -> this.dump());
    }

    public void dumpContinuouslyToLog(long dumpInterval, TimeUnit timeUnit) {
        if (this.logReporter == null) {
            this.logReporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry).outputTo(LoggerFactory.getLogger(Metrics.class)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        } else {
            this.logReporter.close();
        }
        this.logReporter.start(dumpInterval, timeUnit);
    }

    public void dumpToLog() {
        if (this.logReporter == null) {
            this.logReporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry).outputTo(LoggerFactory.getLogger(Metrics.class)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        }
        this.logReporter.report();
    }

    public <T extends Metric> void register(T metric, String idPathFirst, String ... idPathRemainder) {
        this.metricRegistry.register(Metrics.name(idPathFirst, idPathRemainder), metric);
    }

    public boolean remove(String idPathFirst, String ... idPathRemainder) {
        return this.metricRegistry.remove(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Meter getMeter(String idPathFirst, String ... idPathRemainder) {
        return this.metricRegistry.meter(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Counter getCounter(String idPathFirst, String ... idPathRemainder) {
        return this.metricRegistry.counter(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Timer getTimer(String idPathFirst, String ... idPathRemainder) {
        return this.metricRegistry.timer(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Histogram getHistogram(String idPathFirst, String ... idPathRemainder) {
        return this.metricRegistry.histogram(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Gauge getGauge(String idPathFirst, String ... idPathRemainder) {
        String theMetricName = Metrics.name(idPathFirst, idPathRemainder);
        Optional<Map.Entry> gaugeEntry = this.metricRegistry.getGauges().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(theMetricName)).findFirst();
        if (gaugeEntry.isPresent()) {
            return (Gauge)gaugeEntry.get().getValue();
        }
        return (Gauge)this.metricRegistry.register(Metrics.name(idPathFirst, idPathRemainder), (Metric)new SettableGauge());
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }

    public static String name(String idPathFirst, String ... idPathRemainder) {
        return MetricRegistry.name((String)idPathFirst, (String[])idPathRemainder);
    }
}

