/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.filesystem;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public class Filesystem {
    public Flowable<String> readTextFile(String pathToFile) {
        return Flowable.generate(() -> new BufferedReader(new InputStreamReader(new FileInputStream(pathToFile))), (reader, emitter) -> {
            if (reader.ready()) {
                emitter.onNext((Object)reader.readLine());
            } else {
                emitter.onComplete();
            }
        }, reader -> reader.close());
    }

    public Flowable<String> readTextFileFromClasspath(String resourcePath) {
        URL resourceUri = this.getClass().getResource(resourcePath);
        if (resourceUri == null) {
            return Flowable.error((Throwable)new NoSuchFileException(resourcePath));
        }
        return this.readTextFile(this.getClass().getResource(resourcePath).getFile());
    }

    public Single<String> readTextFileFully(String pathToFile) {
        String filePath = this.getWindowsPathUsableForNio(pathToFile);
        return Single.create(s -> {
            AsynchronousFileChannel channel = AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.READ);
            long capacity = channel.size();
            if (capacity > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("File is too big. Max size is 2147483647 bytes.");
            }
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            channel.read(buffer, 0L, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    s.onSuccess((Object)new String(attachment.array()));
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    s.onError(exc);
                }
            });
        });
    }

    public Single<String> readTextFileFullyFromClasspath(String resourcePath) {
        URL resourceUri = this.getClass().getResource(resourcePath);
        if (resourceUri == null) {
            return Single.error((Throwable)new NoSuchFileException(resourcePath));
        }
        return this.readTextFileFully(this.getClass().getResource(resourcePath).getFile());
    }

    private String getWindowsPathUsableForNio(String path) {
        if (path == null) {
            return null;
        }
        char[] pathAsChars = path.toCharArray();
        if (pathAsChars.length > 2 && (pathAsChars[0] == File.pathSeparatorChar || pathAsChars[0] == '/') && Character.isAlphabetic(pathAsChars[1]) && pathAsChars[2] == ':') {
            return path.substring(1);
        }
        return path;
    }

    public Completable writeFile(String content, String filePath) {
        return Completable.create(s -> {
            AsynchronousFileChannel channel = AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            ByteBuffer contentBuffer = ByteBuffer.wrap(content.getBytes());
            channel.write(contentBuffer, 0L, null, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    s.onComplete();
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    s.onError(exc);
                }
            });
        });
    }

    public Completable writeFileSync(String content, String filePath, boolean append) throws IOException {
        return this.writeFileSync(content, StandardCharsets.UTF_8, filePath, append);
    }

    public Completable writeFileSync(String content, Charset encoding, String filePath, boolean append) throws IOException {
        return Completable.create(s -> {
            HashSet<StandardOpenOption> openOptions = new HashSet<StandardOpenOption>();
            openOptions.add(StandardOpenOption.WRITE);
            openOptions.add(StandardOpenOption.SYNC);
            openOptions.add(StandardOpenOption.CREATE);
            if (append) {
                openOptions.add(StandardOpenOption.APPEND);
            }
            FileChannel channel = FileChannel.open(Paths.get(filePath, new String[0]), openOptions, new FileAttribute[0]);
            if (!append) {
                channel.truncate(0L);
            }
            try {
                channel.write(ByteBuffer.wrap(content.getBytes(encoding)));
                s.onComplete();
            }
            catch (Exception e) {
                s.onError((Throwable)e);
            }
            finally {
                channel.close();
            }
        });
    }
}

