/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.metrics;

import ch.squaredesk.nova.metrics.CompoundMetric;
import ch.squaredesk.nova.metrics.Metrics;
import io.dropwizard.metrics5.MetricName;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CpuMeter
implements CompoundMetric {
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private final Method systemCpuLoadRetrievalMethod;
    private final Method processCpuLoadRetrievalMethod;

    public CpuMeter() {
        Method[] availableMethods = this.operatingSystemMXBean.getClass().getDeclaredMethods();
        this.systemCpuLoadRetrievalMethod = Arrays.stream(availableMethods).filter(m -> "getSystemCpuLoad".equals(m.getName())).filter(m -> {
            try {
                m.setAccessible(true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst().orElse(null);
        this.processCpuLoadRetrievalMethod = Arrays.stream(availableMethods).filter(m -> "getProcessCpuLoad".equals(m.getName())).filter(m -> {
            try {
                m.setAccessible(true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst().orElse(null);
    }

    public boolean environmentSupportsCpuMetrics() {
        return this.systemCpuLoadRetrievalMethod != null || this.processCpuLoadRetrievalMethod != null;
    }

    @Override
    public Map<MetricName, Object> getValues() {
        HashMap<MetricName, Object> values = new HashMap<MetricName, Object>();
        if (this.systemCpuLoadRetrievalMethod != null) {
            values.put(Metrics.name("systemLoadPercent", new String[0]), this.invoke(this.systemCpuLoadRetrievalMethod) * 100.0);
        }
        if (this.processCpuLoadRetrievalMethod != null) {
            values.put(Metrics.name("processLoadPercent", new String[0]), this.invoke(this.processCpuLoadRetrievalMethod) * 100.0);
        }
        return values;
    }

    private double invoke(Method m) {
        try {
            return (Double)m.invoke((Object)this.operatingSystemMXBean, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }
}

