/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.metrics;

import ch.squaredesk.nova.metrics.CompoundMetric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MemoryMeter
implements CompoundMetric {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryMeter() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryMeter(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    @Override
    public Map<MetricName, Object> getValues() {
        MemoryUsage nonHeapUsage = this.mxBean.getNonHeapMemoryUsage();
        MemoryUsage heapUsage = this.mxBean.getHeapMemoryUsage();
        HashMap<MetricName, Object> values = new HashMap<MetricName, Object>();
        values.put(MetricRegistry.name((String)"heapInitial", (String[])new String[0]), heapUsage.getInit());
        values.put(MetricRegistry.name((String)"heapUsed", (String[])new String[0]), heapUsage.getUsed());
        values.put(MetricRegistry.name((String)"heapMax", (String[])new String[0]), heapUsage.getMax());
        values.put(MetricRegistry.name((String)"heapCommitted", (String[])new String[0]), heapUsage.getCommitted());
        values.put(MetricRegistry.name((String)"heapFree", (String[])new String[0]), heapUsage.getMax() - heapUsage.getUsed());
        values.put(MetricRegistry.name((String)"heapUsageInPercent", (String[])new String[0]), (double)heapUsage.getUsed() / (double)heapUsage.getMax() * 100.0);
        values.put(MetricRegistry.name((String)"totalInitial", (String[])new String[0]), heapUsage.getInit() + nonHeapUsage.getInit());
        values.put(MetricRegistry.name((String)"totalUsed", (String[])new String[0]), heapUsage.getUsed() + nonHeapUsage.getUsed());
        values.put(MetricRegistry.name((String)"totalMax", (String[])new String[0]), heapUsage.getMax() + nonHeapUsage.getMax());
        values.put(MetricRegistry.name((String)"totalCommitted", (String[])new String[0]), heapUsage.getCommitted() + nonHeapUsage.getCommitted());
        values.put(MetricRegistry.name((String)"totalFree", (String[])new String[0]), heapUsage.getMax() + nonHeapUsage.getMax() - heapUsage.getUsed() - nonHeapUsage.getUsed());
        values.put(MetricRegistry.name((String)"totalUsageInPercent", (String[])new String[0]), ((double)heapUsage.getUsed() + (double)nonHeapUsage.getUsed()) / ((double)heapUsage.getMax() + (double)nonHeapUsage.getMax()) * 100.0);
        for (MemoryPoolMXBean pool : this.memoryPools) {
            String poolName = MetricRegistry.name((String)"pools", (String[])new String[]{WHITESPACE.matcher(pool.getName()).replaceAll("-")}).toString();
            MemoryUsage usage = pool.getUsage();
            values.put(MetricRegistry.name((String)poolName, (String[])new String[]{"usageInPercent"}), (double)usage.getUsed() / (double)(usage.getMax() == -1L ? usage.getCommitted() : usage.getMax()) * 100.0);
            values.put(MetricRegistry.name((String)poolName, (String[])new String[]{"init"}), usage.getMax());
            values.put(MetricRegistry.name((String)poolName, (String[])new String[]{"max"}), usage.getMax());
            values.put(MetricRegistry.name((String)poolName, (String[])new String[]{"max"}), usage.getUsed());
            values.put(MetricRegistry.name((String)poolName, (String[])new String[]{"committed"}), usage.getUsed());
            MemoryUsage collectionUsage = pool.getCollectionUsage();
            if (collectionUsage == null) continue;
            values.put(MetricRegistry.name((String)poolName, (String[])new String[]{"used-after-gc"}), collectionUsage.getUsed());
        }
        return values;
    }
}

