/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.metrics;

import ch.squaredesk.nova.metrics.MetricsDump;
import ch.squaredesk.nova.metrics.SettableGauge;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Slf4jReporter;
import io.dropwizard.metrics5.Timer;
import io.reactivex.Observable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class Metrics {
    public final MetricRegistry metricRegistry = new MetricRegistry();
    private Slf4jReporter logReporter;

    public MetricsDump dump() {
        return new MetricsDump(this.metricRegistry.getMetrics());
    }

    public Observable<MetricsDump> dumpContinuously(long interval, TimeUnit timeUnit) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        Objects.requireNonNull(timeUnit, "timeUnit must not be null");
        return Observable.interval((long)interval, (long)interval, (TimeUnit)timeUnit).map(count -> this.dump());
    }

    public void dumpContinuouslyToLog(long dumpInterval, TimeUnit timeUnit) {
        if (this.logReporter == null) {
            this.logReporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry).outputTo(LoggerFactory.getLogger(Metrics.class)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        } else {
            this.logReporter.close();
        }
        this.logReporter.start(dumpInterval, timeUnit);
    }

    public void dumpToLog() {
        if (this.logReporter == null) {
            this.logReporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry).outputTo(LoggerFactory.getLogger(Metrics.class)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        }
        this.logReporter.report();
    }

    public <T extends Metric> void register(MetricName metricName, T metric) {
        this.metricRegistry.register(metricName, metric);
    }

    public <T extends Metric> void register(T metric, String idPathFirst, String ... idPathRemainder) {
        this.register(Metrics.name(idPathFirst, idPathRemainder), metric);
    }

    public boolean remove(MetricName metricName) {
        return this.metricRegistry.remove(metricName);
    }

    public boolean remove(String idPathFirst, String ... idPathRemainder) {
        return this.remove(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Meter getMeter(MetricName metricName) {
        return this.metricRegistry.meter(metricName);
    }

    public Meter getMeter(String idPathFirst, String ... idPathRemainder) {
        return this.getMeter(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Counter getCounter(MetricName metricName) {
        return this.metricRegistry.counter(metricName);
    }

    public Counter getCounter(String idPathFirst, String ... idPathRemainder) {
        return this.getCounter(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Timer getTimer(MetricName metricName) {
        return this.metricRegistry.timer(metricName);
    }

    public Timer getTimer(String idPathFirst, String ... idPathRemainder) {
        return this.getTimer(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Histogram getHistogram(MetricName metricName) {
        return this.metricRegistry.histogram(metricName);
    }

    public Histogram getHistogram(String idPathFirst, String ... idPathRemainder) {
        return this.getHistogram(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Gauge getGauge(MetricName metricName) {
        Optional<Map.Entry> gaugeEntry = this.metricRegistry.getGauges().entrySet().stream().filter(entry -> ((MetricName)entry.getKey()).equals((Object)metricName)).findFirst();
        if (gaugeEntry.isPresent()) {
            return (Gauge)gaugeEntry.get().getValue();
        }
        return (Gauge)this.metricRegistry.register(metricName, (Metric)new SettableGauge());
    }

    public Gauge getGauge(String idPathFirst, String ... idPathRemainder) {
        return this.getGauge(Metrics.name(idPathFirst, idPathRemainder));
    }

    public Map<MetricName, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }

    public static MetricName name(String idPathFirst, String ... idPathRemainder) {
        return MetricRegistry.name((String)idPathFirst, (String[])idPathRemainder);
    }
}

