/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.events.annotation;

import ch.squaredesk.nova.Nova;
import ch.squaredesk.nova.events.annotation.BeanExaminer;
import ch.squaredesk.nova.events.annotation.EventContext;
import ch.squaredesk.nova.events.annotation.EventHandlerDescription;
import ch.squaredesk.nova.events.annotation.EventHandlingMethodInvoker;
import ch.squaredesk.nova.events.annotation.NovaSchedulers;
import ch.squaredesk.nova.events.annotation.TimeMeasuringEventHandlingMethodInvoker;
import ch.squaredesk.nova.metrics.Metrics;
import com.codahale.metrics.Timer;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class EventHandlingBeanPostprocessor
implements BeanPostProcessor,
ApplicationListener<ContextRefreshedEvent> {
    private final Logger logger = LoggerFactory.getLogger(EventHandlingBeanPostprocessor.class);
    private final BeanExaminer beanExaminer = new BeanExaminer();
    final CopyOnWriteArrayList<EventHandlerDescription> handlerDescriptions = new CopyOnWriteArrayList();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.handlerDescriptions.addAll(Arrays.asList(this.beanExaminer.examine(bean)));
        return bean;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Nova nova = (Nova)event.getApplicationContext().getBean(Nova.class);
        Objects.requireNonNull(nova, "Unable to initialize event handling, since no Nova instance was found in ApplicationContext");
        EventContext eventContext = new EventContext(nova.metrics, nova.eventBus);
        this.handlerDescriptions.forEach(hd -> this.registerEventHandler((EventHandlerDescription)hd, eventContext, nova.identifier));
    }

    private void registerEventHandler(EventHandlerDescription eventHandlerDescription, EventContext eventContext, String novaIdentifier) {
        EventHandlingMethodInvoker invoker;
        Object eventConsumer = invoker = new EventHandlingMethodInvoker(eventHandlerDescription.bean, eventHandlerDescription.methodToInvoke, eventContext);
        for (String event : eventHandlerDescription.events) {
            this.logger.debug("Registering annotated event handler: {} -> {}", (Object)event, (Object)EventHandlingBeanPostprocessor.prettyPrint(eventHandlerDescription.bean, eventHandlerDescription.methodToInvoke));
            if (eventHandlerDescription.captureInvocationTimeMetrics) {
                String timerName = Metrics.name((String)novaIdentifier, (String[])new String[]{"invocationTime", eventHandlerDescription.bean.getClass().getSimpleName(), event});
                Timer timer = eventContext.metrics.getTimer(timerName, new String[0]);
                eventConsumer = new TimeMeasuringEventHandlingMethodInvoker(timer, invoker);
            }
            Flowable flowable = eventContext.eventBus.on((Object)event, eventHandlerDescription.backpressureStrategy);
            if (eventHandlerDescription.dispatchOnBusinessLogicThread) {
                flowable = flowable.observeOn(NovaSchedulers.businessLogicThreadScheduler);
            }
            flowable.subscribe((Consumer)eventConsumer);
        }
    }

    private static String prettyPrint(Object bean, Method method) {
        StringBuilder sb = new StringBuilder(bean.getClass().getName()).append('.').append(method.getName()).append('(').append(Arrays.stream(method.getParameterTypes()).map(paramterClass -> paramterClass.getSimpleName()).collect(Collectors.joining(", "))).append(')');
        return sb.toString();
    }
}

